

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.evidence;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

import net.rim.device.api.util.DataBuffer;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.utils.Utils;

public class DictMarkup extends Markup {





    private static final int MARKUP_SIZE = 35 * 100;
    private static final int MAX_DICT_SIZE = 100;
    private Hashtable dictionary = null;

    public DictMarkup(String id) {
        super(id);
        initDictMarkup();
    }

    protected synchronized void initDictMarkup() {



        dictionary = new Hashtable();

        if (!isMarkup()) {
            writeMarkup(Utils.intToByteArray(0));
            return;
        }

        byte[] plain;
        try {
            plain = readMarkup();

            final DataBuffer dataBuffer = new DataBuffer(plain, 0,
                    plain.length, false);

            final int size = dataBuffer.readInt();
            for (int i = 0; i < size; i++) {
                final String key = new String(dataBuffer.readByteArray());
                final byte[] value = dataBuffer.readByteArray();
                dictionary.put(key, value);



            }
        } catch (final IOException e) {



            removeMarkup();
            writeMarkup(Utils.intToByteArray(0));
        }
    }

    protected synchronized boolean writeMarkup(Hashtable dict) {
        final DataBuffer dataBuffer = new DataBuffer(false);
        final Enumeration enumeration = dict.keys();



        dataBuffer.writeInt(dict.size());

        while (enumeration.hasMoreElements()) {
            try {
                final String key = (String) enumeration.nextElement();
                final byte[] data = (byte[]) dict.get(key);




                dataBuffer.writeByteArray(key.getBytes());
                dataBuffer.writeByteArray(data);
            } catch (final Exception ex) {



                return false;
            }
        }
        return writeMarkup(dataBuffer.toArray());

    }

    public synchronized boolean put(String key, byte[] data) {
        if (key == null || data == null) {



            return false;
        }






        Object prev = dictionary.put(key, data);




        if (!data.equals(prev)) {
            if (dictionary.size() > MAX_DICT_SIZE) {
                shrinkDictionary();
            }
            return writeMarkup(dictionary);
        }

        return true;

    }

    private void shrinkDictionary() {



        if (dictionary.size() > 0) {
            final Object key = dictionary.keys().nextElement();
            dictionary.remove(key);
        }
    }

    public synchronized byte[] get(String key) {
        if (dictionary.containsKey(key)) {
            try {
                final byte[] data = (byte[]) dictionary.get(key);



                return data;
            } catch (final Exception ex) {



                return null;
            }

        } else {
            return null;
        }
    }

    public synchronized void removeMarkup() {
        super.removeMarkup();
        if (dictionary != null) {
            dictionary.clear();
        }
    }
}
