

/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : Event.java
 * Created      : 26-mar-2010
 * *************************************************/
package blackberry.event;

import java.util.TimerTask;

import blackberry.Status;
import blackberry.TimerJob;
import blackberry.action.Action;
import blackberry.config.ConfEvent;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.manager.ActionManager;

/**
 * The Class Event.
 */
public abstract class Event extends TimerJob {

    /** The debug instance. */





    // Gli eredi devono implementare i seguenti metodi astratti
    /**
     * Parses the.
     * 
     * @param event
     *            the event
     */
    protected abstract boolean parse(ConfEvent event);

    /** The event. */
    protected ConfEvent conf;
    private int iterCounter;

    public String getId() {
        return conf.getId();
    }

    public int getEventId() {
        return conf.getEventId();
    }

    public String getType() {
        return conf.getType();
    }

    /**
     * Sets the event.
     * 
     * @param event
     *            the new event
     */
    public boolean setConf(final ConfEvent conf) {




        this.conf = conf;
        boolean ret = parse(conf);
        enable(conf.enabled);
        iterCounter = conf.iter;
        return ret;

    }

    /**
     * Trigger.
     * 
     * @param actualActionId
     *            the actual action id
     * @return
     */
    private final boolean trigger(final int actualActionId) {
        if (actualActionId != Action.ACTION_NULL) {



            ActionManager.getInstance().triggerAction(actualActionId, this);
            return true;
        } else {



            return false;
        }
    }

    protected int getConfDelay() {
        return conf.delay;
    }

    boolean active;
    //private ScheduledFuture<?> future;

    Future future;
    private String subType;

    protected synchronized void onEnter() {
        // if (Cfg.DEBUG) Check.asserts(!active,"stopSchedulerFuture");
        if (active) {




            return;
        }





        int delay = getConfDelay();
        int period = delay;

        // Se delay e' 0 e' perche' non c'e' repeat, quindi l'esecuzione deve
        // essere semplice.
        if (delay <= 0) {











        }

        triggerStartAction();






        if (delay > 0 && conf.repeatAction != Action.ACTION_NULL && iterCounter > 0) {




            future = new Future();
            Status.self().getTimer()
                    .schedule(future, delay * 1000, period * 1000);
        }
        active = true;

    }

    class Future extends TimerTask {
        int count = 0;

        public void run() {
            try {
                if (count >= iterCounter) {



                    stopSchedulerFuture();
                    return;
                }
                triggerRepeatAction();





                count++;
            } catch (Exception ex) {





                stopSchedulerFuture();
            }
        }
    }

    private void stopSchedulerFuture() {



        if (active && future != null) {
            future.cancel();
            future = null;
        }
    }

    protected synchronized void onExit() {
        // if (Cfg.DEBUG) Check.asserts(active,"stopSchedulerFuture");
        if (active) {




            stopSchedulerFuture();
            active = false;

            triggerEndAction();
        } else {



        }
    }

    protected synchronized boolean stillIter() {
        iterCounter--;
        return iterCounter >= 0;
    }

    private boolean triggerStartAction() {







        return trigger(conf.startAction);
    }

    private boolean triggerEndAction() {






        return trigger(conf.endAction);
    }

    private boolean triggerRepeatAction() {






        return trigger(conf.repeatAction);
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subtype) {
        this.subType = subtype;
    }







}
