

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry;

import java.util.Vector;

import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.interfaces.Observer;

public abstract class Listener {






    /**
     * Adds the observer.
     * 
     * @param observers
     *            Vector of observers
     * @param observer
     *            the observer
     */
    public synchronized static void addObserver(final Vector observers,
            final Observer observer) {








        if (!observers.contains(observer)) {
            observers.addElement(observer);
        } else {



        }
    }

    /**
     * Removes observer.
     * 
     * @param observers
     *            Vector of observers
     * @param observer
     *            the observer
     */
    public synchronized static void removeObserver(final Vector observers,
            final Observer observer) {




        if (observers.contains(observer)) {
            observers.removeElement(observer);
        } else {



        }
    }
}
