/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna;

import de.pleumann.antenna.misc.Base64;
import de.pleumann.antenna.misc.JadFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WtkSign
extends Task {
    private File m_keyStore;
    private File m_jarFile;
    private File m_jadFile;
    private String m_storePass = "";
    private String m_certPass = "";
    private String m_certAlias;
    private int m_certNum = 1;
    private String m_jadEncoding = "UTF-8";
    private String m_storeType = KeyStore.getDefaultType();

    public WtkSign() {
        this.m_keyStore = new File(System.getProperty("user.home") + File.separator + ".keystore");
    }

    public void setCertAlias(String certAlias) {
        this.m_certAlias = certAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.m_jarFile == null) {
            throw new BuildException("jarfile is not set");
        }
        if (this.m_jadFile == null) {
            throw new BuildException("jadfile is not set");
        }
        if (this.m_certAlias == null) {
            throw new BuildException("certalias is not set");
        }
        if (!this.m_jarFile.exists()) {
            throw new BuildException("jarfile " + this.m_jarFile + " does not exist");
        }
        if (!this.m_jadFile.exists()) {
            throw new BuildException("jadfile " + this.m_jadFile + " does not exist");
        }
        FileInputStream ksin = null;
        FileInputStream jin = null;
        try {
            int len;
            Object key;
            JadFile jadfile = new JadFile();
            jadfile.load(this.m_jadFile.getAbsolutePath(), this.m_jadEncoding);
            KeyStore keystore = KeyStore.getInstance(this.m_storeType);
            ksin = new FileInputStream(this.m_keyStore);
            keystore.load(ksin, this.m_storePass.toCharArray());
            Certificate[] certificates = keystore.getCertificateChain(this.m_certAlias);
            if (certificates == null) {
                throw new BuildException("Certificate chain " + this.m_certAlias + " not found in key store");
            }
            for (int i = 0; i < certificates.length; ++i) {
                key = "MIDlet-Certificate-" + this.m_certNum + "-" + (i + 1);
                String value = Base64.encodeBytes(certificates[i].getEncoded(), 8);
                jadfile.setValue((String)key, value);
            }
            jin = new FileInputStream(this.m_jarFile);
            this.log("Signing jar " + this.m_jarFile);
            this.log("Key store : " + this.m_keyStore);
            this.log("Cert alias : " + this.m_certAlias);
            Signature signature = Signature.getInstance("SHA1withRSA");
            key = (PrivateKey)keystore.getKey(this.m_certAlias, this.m_certPass.toCharArray());
            signature.initSign((PrivateKey)key);
            int t = 0;
            byte[] buf = new byte[4096];
            while ((len = jin.read(buf)) != -1) {
                t += len;
                signature.update(buf, 0, len);
            }
            byte[] sign = signature.sign();
            String sigStr = Base64.encodeBytes(sign, 8);
            jadfile.setValue("MIDlet-Jar-RSA-SHA1", sigStr);
            jadfile.save(this.m_jadFile.getAbsolutePath(), this.m_jadEncoding);
        }
        catch (IOException e) {
            this.error(e);
        }
        catch (KeyStoreException e) {
            this.error(e);
        }
        catch (NoSuchAlgorithmException e) {
            this.error(e);
        }
        catch (CertificateException e) {
            this.error(e);
        }
        catch (UnrecoverableKeyException e) {
            this.error(e);
        }
        catch (InvalidKeyException e) {
            this.error(e);
        }
        catch (SignatureException e) {
            this.error(e);
        }
        finally {
            if (ksin != null) {
                try {
                    ksin.close();
                }
                catch (IOException e1) {}
            }
            if (jin != null) {
                try {
                    jin.close();
                }
                catch (IOException e1) {}
            }
        }
    }

    private void error(Exception e) {
        this.log(e.getMessage());
        throw new BuildException((Throwable)e);
    }

    public void setCertNum(int certNum) {
        this.m_certNum = certNum;
    }

    public void setJadFile(File jadFile) {
        this.m_jadFile = jadFile;
    }

    public void setJarFile(File jarFile) {
        this.m_jarFile = jarFile;
    }

    public void setCertPass(String keypass) {
        this.m_certPass = keypass;
    }

    public void setKeyStore(File keyStore) {
        this.m_keyStore = keyStore;
    }

    public void setStorePass(String storePass) {
        this.m_storePass = storePass;
    }

    public void setJadEncoding(String jadEncoding) {
        this.m_jadEncoding = jadEncoding;
    }

    public void setStoreType(String storeType) {
        this.m_storeType = storeType;
    }
}

