/*
 * Decompiled with CFR 0.152.
 */
package ca.slashdev.bb.types;

import ca.slashdev.bb.types.CodSetType;
import ca.slashdev.bb.util.Utils;
import ca.slashdev.bb.util.VersionMatch;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.ResourceUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApplicationType
extends DataType {
    private String id;
    private String name;
    private String description;
    private String version;
    private String vendor;
    private String copyright;
    private VersionMatch greater;
    private VersionMatch less;
    private Vector<CodSetType> codSets = new Vector();

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTitle(String name) {
        this.name = name;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setGreaterThan(String version) throws BuildException {
        this.greater = new VersionMatch(version, false);
    }

    public void setGreaterThanEqual(String version) {
        this.greater = new VersionMatch(version, true);
    }

    public void setLessThan(String version) {
        this.less = new VersionMatch(version, false);
    }

    public void setLessThanEqual(String version) {
        this.less = new VersionMatch(version, true);
    }

    public boolean hasVersionMatch() {
        return this.greater != null || this.less != null;
    }

    public void addCodSet(CodSetType codSet) {
        this.codSets.add(codSet);
    }

    public String getVersionMatch() {
        StringBuffer val = new StringBuffer();
        if (this.greater != null) {
            val.append(this.greater.isInclusive() ? "[" : "(");
            val.append(this.greater.getVersion()).append(',');
        } else {
            val.append("(,");
        }
        if (this.less != null) {
            val.append(this.less.getVersion()).append(this.less.isInclusive() ? "]" : ")");
        } else {
            val.append(")");
        }
        return val.toString();
    }

    public void setFile(File file) throws BuildException {
        FileInputStream in = null;
        if (!file.isFile()) {
            throw new BuildException("file attribute must be a properties file");
        }
        try {
            in = new FileInputStream(file);
            Properties props = new Properties();
            props.load(in);
            this.id = props.getProperty("id");
            this.name = props.getProperty("name");
            if (this.name == null) {
                this.name = props.getProperty("title");
            }
            this.description = props.getProperty("description");
            this.version = props.getProperty("version");
            this.vendor = props.getProperty("vendor");
            this.copyright = props.getProperty("copyright");
        }
        catch (IOException e) {
            throw new BuildException("error loading properties", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void generate(Document xmldoc, Element parent) {
        if (this.id == null) {
            throw new BuildException("id attribute is reqired");
        }
        Element appNode = xmldoc.createElement("application");
        parent.appendChild(appNode);
        appNode.setAttribute("id", this.id);
        String appBBVer = null;
        if (this.hasVersionMatch()) {
            appBBVer = this.getVersionMatch();
            appNode.setAttribute("_blackberryVersion", appBBVer);
        }
        Element child = xmldoc.createElement("name");
        appNode.appendChild(child);
        if (this.name != null) {
            child.setTextContent(this.name);
        }
        child = xmldoc.createElement("description");
        appNode.appendChild(child);
        if (this.description != null) {
            child.setTextContent(this.description);
        }
        child = xmldoc.createElement("version");
        appNode.appendChild(child);
        if (this.version != null) {
            child.setTextContent(this.version);
        }
        child = xmldoc.createElement("vendor");
        appNode.appendChild(child);
        if (this.vendor != null) {
            child.setTextContent(this.vendor);
        }
        child = xmldoc.createElement("copyright");
        appNode.appendChild(child);
        if (this.copyright != null) {
            child.setTextContent(this.copyright);
        }
        for (CodSetType codSet : this.codSets) {
            String codSetBBVer = null;
            if (codSet.hasVersionMatch()) {
                codSetBBVer = codSet.getVersionMatch();
            }
            Element filesetNode = xmldoc.createElement("fileset");
            appNode.appendChild(filesetNode);
            filesetNode.setAttribute("Java", "1.0");
            if (codSetBBVer != null) {
                filesetNode.setAttribute("_blackberryVersion", codSetBBVer);
            }
            if (codSet.getDir() != null) {
                child = xmldoc.createElement("directory");
                filesetNode.appendChild(child);
                child.setTextContent(codSet.getDir());
            }
            StringBuffer files = new StringBuffer();
            Iterator i = codSet.getResources().iterator();
            while (i.hasNext()) {
                files.append('\n').append(Utils.getFilePart((Resource)i.next()));
            }
            files.append('\n');
            Element filesNode = xmldoc.createElement("files");
            filesNode.setTextContent(files.toString());
            filesetNode.appendChild(filesNode);
        }
    }

    public void copyCodFiles(File destDir) throws IOException {
        for (CodSetType codSet : this.codSets) {
            File codSetDestDir = destDir;
            if (codSet.getDir() != null && !(codSetDestDir = new File(destDir, codSet.getDir())).exists() && !codSetDestDir.mkdirs()) {
                throw new IOException("unable to create cod files director");
            }
            for (Resource r : codSet.getResources()) {
                FileResource destFile;
                if (r.equals((Object)(destFile = new FileResource(codSetDestDir, Utils.getFilePart(r))))) continue;
                ResourceUtils.copyResource((Resource)r, (Resource)destFile);
            }
        }
    }
}

