/*
 * Decompiled with CFR 0.152.
 */
package ca.slashdev.bb.tasks;

import ca.slashdev.bb.tasks.BaseTask;
import ca.slashdev.bb.types.JdpType;
import ca.slashdev.bb.util.Utils;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.util.FileUtils;

public class RapcTask
extends BaseTask {
    private File jdkHome;
    private File destDir;
    private String output;
    private boolean quiet = true;
    private boolean verbose;
    private boolean nodebug;
    private boolean nowarn;
    private boolean warnerror;
    private boolean noconvert;
    private boolean nopreverify;
    private boolean generateSourceList = false;
    private String sourceListFile = "sources.txt";
    private Path srcs;
    private Path imports;
    private File exePath;
    private JdpType jdp = new JdpType();
    private String definesLine;
    private Vector<Define> defines = new Vector();

    public void init() throws BuildException {
        this.srcs = new Path(this.getProject());
        this.imports = new Path(this.getProject());
        super.init();
    }

    public void setJdeHome(File jdeHome) {
        super.setJdeHome(jdeHome);
    }

    public void setJdkHome(File jdkHome) {
        File bin = new File(jdkHome, "bin");
        if (!bin.isDirectory()) {
            throw new BuildException("jdk home missing \"bin\" directory");
        }
        this.jdkHome = jdkHome;
    }

    public void setExePath(File exePath) {
        this.exePath = exePath;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNodebug(boolean nodebug) {
        this.nodebug = nodebug;
    }

    public void setNowarn(boolean nowarn) {
        this.nowarn = nowarn;
    }

    public void setWarnerror(boolean warnerror) {
        this.warnerror = warnerror;
    }

    public void setNoconvert(boolean noconvert) {
        this.noconvert = noconvert;
    }

    public void setNopreverify(boolean nopreverify) {
        this.nopreverify = nopreverify;
    }

    public void setGenerateSourceList(boolean generateSourceList) {
        this.generateSourceList = generateSourceList;
    }

    public void setSourceListFile(String sourceListFile) {
        this.sourceListFile = sourceListFile;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setSrcDir(File srcDir) {
        FileSet srcFiles = new FileSet();
        srcFiles.setDir(srcDir);
        this.srcs.addFileset(srcFiles);
    }

    public void setImport(Path importPath) {
        this.imports.add(importPath);
    }

    public void setImportRef(Reference importRef) {
        Object obj = importRef.getReferencedObject(this.getProject());
        if (!(obj instanceof Path)) {
            throw new BuildException("importref must be a path");
        }
        this.imports.add((Path)obj);
    }

    public void addSrc(Path srcPath) {
        this.srcs.add(srcPath);
    }

    public void addImport(Path importPath) {
        this.imports.add(importPath);
    }

    public void addJdp(JdpType jdp) {
        this.jdp = jdp;
    }

    public void setDefines(String defines) {
        this.definesLine = defines;
    }

    public void addDefine(Define def) {
        this.defines.add(def);
    }

    public void execute() throws BuildException {
        super.execute();
        if (this.jdeHome == null) {
            throw new BuildException("jdehome not set");
        }
        File lib = new File(this.jdeHome, "lib");
        if (!lib.isDirectory()) {
            throw new BuildException("jde home missing \"lib\" directory");
        }
        Path apiPath = new Path(this.getProject());
        apiPath.setLocation(new File(lib, "net_rim_api.jar"));
        this.imports.add(apiPath);
        if (this.output == null) {
            throw new BuildException("output is a required attribute");
        }
        if (this.destDir == null) {
            this.destDir = this.getProject().getBaseDir();
        } else if (!this.destDir.isDirectory()) {
            throw new BuildException("destdir must be a directory");
        }
        if (this.srcs.size() == 0) {
            throw new BuildException("srcdir attribute or <src> element required!");
        }
        String[] files = this.srcs.list();
        this.srcs = new Path(this.getProject());
        for (String file : files) {
            File f = new File(file);
            if (f.isDirectory()) {
                FileSet fs = new FileSet();
                fs.setDir(f);
                this.srcs.addFileset(fs);
                continue;
            }
            this.srcs.setLocation(f);
        }
        this.jdp.writeManifest(new File(this.destDir, this.output + ".rapc"), this.output);
        if (!Utils.isUpToDate((ResourceCollection)this.srcs, new File(this.destDir, this.output + ".cod"))) {
            this.log(String.format("Compiling %d source files to %s", this.srcs.size(), this.output + ".cod"));
            this.executeRapc();
        } else {
            this.log("Compilation skipped, cod is up to date", 3);
        }
    }

    protected void executeRapc() {
        Java java;
        block32: {
            block31: {
                File bin = new File(this.jdeHome, "bin");
                if (!bin.isDirectory()) {
                    throw new BuildException("jde home missing \"bin\" directory");
                }
                File rapcJar = new File(bin, "rapc.jar");
                java = (Java)this.getProject().createTask("java");
                java.setTaskName(this.getTaskName());
                java.setClassname("net.rim.tools.compiler.Compiler");
                java.setFork(true);
                java.setFailonerror(true);
                List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
                for (String arg : jvmArgs) {
                    java.createJvmarg().setValue(arg);
                }
                Vector env = Execute.getProcEnvironment();
                for (String line : env) {
                    if (!line.toUpperCase().startsWith("PATH")) continue;
                    Environment.Variable var = new Environment.Variable();
                    var.setKey("PATH");
                    var.setFile(new File(this.jdeHome, "bin"));
                    var.setValue(String.format("%s%c%s", line.substring(line.indexOf(61) + 1), Character.valueOf(File.pathSeparatorChar), var.getValue()));
                    java.addEnv(var);
                    break;
                }
                if (this.jdkHome != null) {
                    java.setJvm(String.format("%s%c%s", new File(this.jdkHome, "bin").getAbsolutePath(), Character.valueOf(File.separatorChar), "java"));
                }
                java.setDir(this.destDir);
                java.createClasspath().setLocation(rapcJar);
                if (this.verbose) {
                    java.createArg().setValue("-verbose");
                } else if (this.quiet) {
                    java.createArg().setValue("-quiet");
                }
                if (this.nodebug) {
                    java.createArg().setValue("-nodebug");
                }
                if (this.nowarn) {
                    java.createArg().setValue("-noWarn");
                }
                if (this.warnerror) {
                    java.createArg().setValue("-wx");
                }
                if (this.noconvert) {
                    java.createArg().setValue("-noconvertpng");
                }
                if (this.nopreverify) {
                    java.createArg().setValue("-nopreverified");
                }
                if (this.exePath != null) {
                    java.createArg().setValue("-exepath=" + this.exePath.getAbsolutePath());
                }
                if (this.definesLine != null || this.defines.size() > 0) {
                    StringBuffer def = new StringBuffer();
                    if (this.definesLine != null) {
                        def.append(File.pathSeparatorChar).append(this.definesLine);
                    }
                    for (Define define : this.defines) {
                        if (!define.valid(this.getProject())) continue;
                        def.append(File.pathSeparatorChar).append(define);
                    }
                    String defs = def.toString();
                    if (defs.length() > 0) {
                        if (defs.indexOf(59) != -1 && File.pathSeparatorChar == ':') {
                            this.log("converting Windows style path separators to Unix style", 1);
                            defs = defs.replace(';', ':');
                        } else if (defs.indexOf(58) != -1 && File.pathSeparatorChar == ';') {
                            this.log("converting Unix style path separators to Windows style", 1);
                            defs = defs.replace(':', ';');
                        }
                    }
                    java.createArg().setValue("-define=PREPROCESSOR" + File.pathSeparatorChar + defs);
                }
                java.createArg().setValue("import=" + this.imports.toString());
                String type = this.jdp.getType().getValue();
                if ("midlet".equals(type)) {
                    java.createArg().setValue("codename=" + this.output);
                    java.createArg().setValue("-midlet");
                } else if ("cldc".equals(type)) {
                    java.createArg().setValue("codename=" + this.output);
                } else if ("library".equals(type)) {
                    java.createArg().setValue("library=" + this.output);
                }
                java.createArg().setValue(this.output + ".rapc");
                if (!this.generateSourceList) break block31;
                PrintStream output = null;
                try {
                    output = new PrintStream(new File(this.destDir, this.sourceListFile));
                    for (String file : this.srcs.list()) {
                        output.println(file);
                    }
                    java.createArg().setValue("@" + this.sourceListFile);
                }
                catch (Exception e) {
                    try {
                        throw new BuildException("error creating source list file", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(output);
                        throw throwable;
                    }
                }
                FileUtils.close((OutputStream)output);
                break block32;
            }
            for (String file : this.srcs.list()) {
                java.createArg().setFile(new File(file));
            }
        }
        this.log(java.getCommandLine().toString(), 4);
        java.execute();
    }

    public static class Define {
        private String tag;
        private String ifCond;
        private String unlessCond;

        public String getTag() {
            return this.tag;
        }

        public void setTag(String val) {
            this.tag = val;
        }

        public void setIf(String ifCond) {
            this.ifCond = ifCond;
        }

        public void setUnless(String unlessCond) {
            this.unlessCond = unlessCond;
        }

        public String toString() {
            return this.tag;
        }

        public boolean valid(Project p) {
            if (this.ifCond != null && p.getProperty(this.ifCond) == null) {
                return false;
            }
            return this.unlessCond == null || p.getProperty(this.unlessCond) == null;
        }
    }
}

