/*
 * Decompiled with CFR 0.152.
 */
package ca.slashdev.bb.tasks;

import ca.slashdev.bb.tasks.BaseTask;
import ca.slashdev.bb.types.ApplicationType;
import java.io.File;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AlxTask
extends BaseTask {
    private String fileName;
    private File destDir;
    private Vector<ApplicationType> apps = new Vector();

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void addApplication(ApplicationType app) {
        this.apps.add(app);
    }

    public void execute() throws BuildException {
        super.execute();
        if (this.destDir == null) {
            throw new BuildException("destdir is a required attribute");
        }
        if (this.fileName == null) {
            throw new BuildException("filename is a required attribute");
        }
        this.executeAlx();
    }

    private void executeAlx() {
        try {
            if (!this.destDir.exists() && !this.destDir.mkdirs()) {
                throw new BuildException("unable to create destination director");
            }
            File destFile = new File(this.destDir, this.fileName);
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document xmldoc = impl.createDocument(null, "loader", null);
            Element root = xmldoc.getDocumentElement();
            root.setAttribute("version", "1.0");
            for (ApplicationType app : this.apps) {
                app.copyCodFiles(this.destDir);
                app.generate(xmldoc, root);
            }
            DOMSource domSource = new DOMSource(xmldoc);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            StreamResult streamResult = new StreamResult(destFile);
            serializer.transform(domSource, streamResult);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

