/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna;

import de.pleumann.antenna.misc.Conditional;
import de.pleumann.antenna.misc.JadFile;
import de.pleumann.antenna.misc.Utility;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;

public class WtkMakePrc
extends Task {
    private Utility utility;
    private Conditional condition;
    private File prcFile;
    private File jadFile;
    private File jarFile;
    private File icon;
    private File smallicon;
    private String name;
    private String longname;
    private String creator;
    private String type = "Data";
    private boolean highres = false;
    private String converter;
    private String encoding;

    public void init() throws BuildException {
        super.init();
        this.utility = Utility.getInstance(this.getProject(), this);
        this.condition = new Conditional(this.getProject());
        this.converter = this.getProject().getProperty("wtk.wme.home") != null ? "wme" : "wtk";
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setIcon(File icon) {
        this.icon = icon;
    }

    public void setJadFile(File jadFile) {
        this.jadFile = jadFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public void setLongname(String longname) {
        this.longname = longname;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrcFile(File prcFile) {
        this.prcFile = prcFile;
    }

    public void setSmallicon(File smallicon) {
        this.smallicon = smallicon;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHighres(boolean highres) {
        this.highres = highres;
    }

    public void setIf(String s) {
        this.condition.setIf(s);
    }

    public void setUnless(String s) {
        this.condition.setUnless(s);
    }

    public void setConverter(String s) {
        this.converter = s;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isActive() {
        return this.condition.isActive();
    }

    public void executeWtk() throws BuildException {
        String prc;
        JadFile jad = new JadFile();
        if (this.jadFile != null) {
            try {
                jad.load(this.jadFile.getAbsolutePath(), this.encoding);
            }
            catch (IOException ex) {
                throw new BuildException("Error loading JAD file", (Throwable)ex);
            }
        }
        if (this.prcFile == null) {
            prc = (this.jadFile == null ? this.jarFile : this.jadFile).getAbsolutePath();
            prc = prc.substring(0, prc.lastIndexOf(46)) + ".prc";
        } else {
            prc = this.prcFile.getAbsolutePath();
        }
        String converter = this.utility.getWtkRelative("wtklib/devices/PalmOS_Device/converter.jar");
        Java java = new Java();
        java.setProject(this.getProject());
        java.setTaskName(this.getTaskName());
        java.createClasspath().setPath(converter);
        java.setClassname("com.sun.midp.palm.database.MakeMIDPApp");
        java.setFork(true);
        java.setFailonerror(true);
        java.createArg().setLine(" -o \"" + prc + "\"");
        if (this.creator != null) {
            java.createArg().setLine(" -creator \"" + this.creator + "\"");
        }
        if (this.icon != null) {
            java.createArg().setLine(" -icon \"" + this.icon + "\"");
        }
        if (this.smallicon != null) {
            java.createArg().setLine(" -smallicon \"" + this.smallicon + "\"");
        }
        if (this.name != null) {
            java.createArg().setLine(" -name \"" + this.name + "\"");
        }
        if (this.longname != null) {
            java.createArg().setLine(" -longname \"" + this.longname + "\"");
        }
        if (this.type != null) {
            java.createArg().setLine(" -type " + this.type);
        }
        if (this.jadFile != null) {
            java.createArg().setLine(" -jad \"" + this.jadFile + "\"");
        }
        if (this.jarFile != null) {
            java.createArg().setFile(this.jarFile);
        } else {
            java.createArg().setFile(new File(this.jadFile.getParent(), new File(jad.getValue("MIDlet-Jar-URL")).getName()));
        }
        this.log("Generating PRC file " + new File(prc).getName() + " using WTK");
        this.utility.delete(new File(prc));
        java.execute();
        if (!new File(prc).exists()) {
            this.log("There was a problem generating the PRC file. Maybe you are using");
            this.log("the Wireless Toolkit 2.x (and thus MIDP 2.0), which doesn't contain");
            this.log("the PalmOS converter any longer because SUN's MIDP for PalmOS supports");
            this.log("MIDP 1.0 only. In this case, please switch back to an older Wireless");
            this.log("Toolkit. Alternatively, you might want to use the PRC converter from");
            this.log("IBM's Websphere Micro Environment Toolkit for PalmOS.");
            throw new BuildException("Unable to generate PRC file - please check arguments.");
        }
    }

    public void executeWme() throws BuildException {
        String prc;
        String wme = this.getProject().getProperty("wtk.wme.home");
        if (wme == null || !new File(wme + "/bin/jartoprc.exe").exists()) {
            throw new BuildException("IBM PRC generator not found. Please define wtk.wme.home properly.");
        }
        if (this.prcFile == null) {
            prc = (this.jadFile == null ? this.jarFile : this.jadFile).getAbsolutePath();
            prc = prc.substring(0, prc.lastIndexOf(46)) + ".prc";
        } else {
            prc = this.prcFile.getAbsolutePath();
        }
        if (this.jarFile == null) {
            JadFile jad = new JadFile();
            if (this.jadFile != null) {
                try {
                    jad.load(this.jadFile.getAbsolutePath(), this.encoding);
                    this.jarFile = new File(jad.getValue("MIDlet-Jar-URL"));
                    if (!this.jarFile.isAbsolute()) {
                        this.jarFile = new File(this.jadFile.getParentFile(), this.jarFile.getName());
                    }
                }
                catch (IOException ex) {
                    throw new BuildException("Error loading JAD file", (Throwable)ex);
                }
            }
        }
        String executable = this.utility.getQuotedName(new File(wme + "/bin/jartoprc.exe"));
        StringBuffer arguments = new StringBuffer();
        if (this.name == null) {
            String fileSeparator = System.getProperty("file.separator");
            int begin = prc.lastIndexOf(fileSeparator);
            int end = prc.lastIndexOf(46);
            this.name = prc.substring(begin, end);
        }
        arguments.append(" -name:").append(this.name);
        if (this.creator != null) {
            arguments.append(" -id:").append(this.creator);
        }
        if (this.icon != null) {
            arguments.append(" -lgicon:").append("\"").append(this.icon).append("\"");
        }
        if (this.smallicon != null) {
            arguments.append(" -smicon:").append("\"").append(this.smallicon).append("\"");
        }
        if (this.jadFile != null) {
            arguments.append(" -jad:").append("\"").append(this.jadFile).append("\"");
        } else if (this.jarFile != null) {
            arguments.append(" -jar:").append("\"").append(this.jarFile).append("\"");
        } else {
            throw new BuildException("JAD & JAR missing, PRC cannot be generated");
        }
        if (this.highres) {
            arguments.append(" -highres");
        }
        this.log("Executable: " + executable, 3);
        this.log("Arguments : " + arguments, 3);
        this.log("Generating PRC file " + new File(prc).getName() + " using WME");
        try {
            Process proc = Runtime.getRuntime().exec(executable + " " + arguments, null, new File(wme + "/bin"));
            proc.waitFor();
            this.utility.printProcessOutput(proc);
            if (proc.exitValue() != 0) {
                throw new BuildException("PRC generation failed (result=" + proc.exitValue() + ")");
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (InterruptedException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public void execute() throws BuildException {
        if (!this.isActive()) {
            return;
        }
        if (this.jadFile == null && this.jarFile == null) {
            throw new BuildException("Need either a JAR file or a JAD file");
        }
        if ("wme".equalsIgnoreCase(this.converter)) {
            this.executeWme();
        } else {
            this.executeWtk();
        }
    }
}

