/*
 * Decompiled with CFR 0.152.
 */
package ca.slashdev.bb.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.util.FileUtils;

public final class Utils {
    private static final byte[] ZIP_MAGIC = new byte[]{80, 75, 3, 4};

    public static String getFilePart(Resource r) {
        String path = r.getName();
        if (path.indexOf(47) != -1) {
            path = path.substring(path.lastIndexOf(47) + 1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZip(Resource r) throws IOException {
        InputStream in = null;
        try {
            in = r.getInputStream();
            byte[] magic = new byte[4];
            if (in.read(magic) != 4) {
                throw new IOException("unable to read 4 bytes from resource");
            }
            boolean bl = Arrays.equals(magic, ZIP_MAGIC);
            return bl;
        }
        finally {
            FileUtils.close((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] extract(Resource r, File destDir) throws IOException {
        FileOutputStream output = null;
        Vector<String> entries = new Vector<String>();
        byte[] buf = new byte[1024];
        ZipInputStream input = null;
        try {
            input = new ZipInputStream(r.getInputStream());
            ZipEntry entry = input.getNextEntry();
            while (entry != null) {
                try {
                    int sz;
                    entries.add(entry.getName());
                    output = new FileOutputStream(new File(destDir, entry.getName()));
                    while ((sz = input.read(buf)) != -1) {
                        output.write(buf, 0, sz);
                    }
                }
                catch (Throwable throwable) {
                    input.closeEntry();
                    FileUtils.close(output);
                    throw throwable;
                }
                input.closeEntry();
                FileUtils.close((OutputStream)output);
                entry = input.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(input);
            throw throwable;
        }
        FileUtils.close((InputStream)input);
        return entries.toArray(new String[0]);
    }

    public static String getSHA1(File file) throws IOException {
        String string;
        FileInputStream in = null;
        try {
            int sz;
            in = new FileInputStream(file);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((sz = ((InputStream)in).read(buf)) != -1) {
                buffer.write(buf, 0, sz);
            }
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(buffer.toByteArray());
            byte[] hash = md.digest();
            StringBuffer str = new StringBuffer();
            for (byte b : hash) {
                str.append(' ');
                str.append(String.format("%02x", b & 0xFF));
            }
            string = str.toString();
        }
        catch (NoSuchAlgorithmException e) {
            try {
                throw new RuntimeException("weird, everyone has this algo", e);
            }
            catch (Throwable throwable) {
                FileUtils.close(in);
                throw throwable;
            }
        }
        FileUtils.close((InputStream)in);
        return string;
    }

    public static boolean isUpToDate(ResourceCollection src, File target) {
        if (!target.exists()) {
            return false;
        }
        long targetLastModified = target.lastModified();
        Iterator i = src.iterator();
        while (i.hasNext()) {
            if (((Resource)i.next()).getLastModified() <= targetLastModified) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpToDate(File src, File target) {
        if (!target.exists()) {
            return false;
        }
        return target.lastModified() >= src.lastModified();
    }

    public static String join(String[] parts) {
        if (parts != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length; ++i) {
                sb.append(parts[i]);
                if (i == parts.length - 1) continue;
                sb.append(',');
            }
            return sb.toString();
        }
        return null;
    }
}

