/*
 * Decompiled with CFR 0.152.
 */
package ca.slashdev.bb.types;

import ca.slashdev.bb.types.BaseJdpType;
import ca.slashdev.bb.types.EntryPointType;
import ca.slashdev.bb.types.TypeAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class JdpType
extends BaseJdpType {
    private TypeAttribute type;
    private String version = "0.0";
    private String vendor = "<unknown>";
    private String description;
    private String midletClass = "";
    private List<EntryPointType> entryPoints = new ArrayList<EntryPointType>();

    public JdpType() {
        this.type = new TypeAttribute();
        this.type.setValue("cldc");
    }

    public TypeAttribute getType() {
        return this.type;
    }

    public void setType(TypeAttribute type) {
        this.type = type;
    }

    public String getMidletClass() {
        return this.midletClass;
    }

    public void setMidletClass(String midletClass) {
        this.midletClass = midletClass;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setStartupTier(int startupTier) {
        if (startupTier < 0 || startupTier > 7) {
            throw new BuildException("startuptier must be between 0 and 7");
        }
        this.startupTier = startupTier;
    }

    public boolean isSystemModule() {
        return this.systemModule;
    }

    public void setSystemModule(boolean systemModule) {
        this.systemModule = systemModule;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void addEntry(EntryPointType entry) {
        this.entryPoints.add(entry);
    }

    public void setFile(File file) throws BuildException {
        super.setFile(file);
        FileInputStream in = null;
        if (!file.isFile()) {
            throw new BuildException("file attribute must be a properties file");
        }
        try {
            in = new FileInputStream(file);
            Properties props = new Properties();
            props.load(in);
            this.type.setValue(props.getProperty("type", "cldc"));
            this.version = props.getProperty("version", "0.0");
            this.vendor = props.getProperty("vendor", "<unknown>");
            this.description = props.getProperty("description");
            this.midletClass = props.getProperty("midletclass", "");
        }
        catch (IOException e) {
            throw new BuildException("error loading properties", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void writeManifest(File file, String output) throws BuildException {
        PrintStream out = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            out = new PrintStream(file);
            out.printf("MIDlet-Name: %s\n", output);
            out.printf("MIDlet-Version: %s\n", this.version);
            out.printf("MIDlet-Vendor: %s\n", this.vendor);
            if (this.description != null) {
                out.printf("MIDlet-Description: %s\n", this.description);
            }
            out.printf("MIDlet-Jar-URL: %s.jar\n", output);
            out.println("MIDlet-Jar-Size: 0");
            out.println("MicroEdition-Profile: MIDP-2.0");
            out.println("MicroEdition-Configuration: CLDC-1.1");
            if ("cldc".equals(this.type.getValue())) {
                out.printf("MIDlet-1: %s,%s,%s\n", this.title, this.getFirstIcon(), this.arguments);
                if (this.ribbonPosition > 0) {
                    out.printf("RIM-MIDlet-Position-1: %d\n", this.ribbonPosition);
                }
                if (this.nameResourceBundle != null && this.nameResourceId > -1) {
                    out.printf("RIM-MIDlet-NameResourceBundle-1: %s\n", this.nameResourceBundle);
                    out.printf("RIM-MIDlet-NameResourceId-1: %d\n", this.nameResourceId);
                }
                int iconIndex = 0;
                for (int i = 1; i < this.icons.length; ++i) {
                    out.printf("RIM-MIDlet-Icon-1-%d: %s\n", ++iconIndex, this.icons[i]);
                }
                for (String icon : this.focusIcons) {
                    out.printf("RIM-MIDlet-Icon-1-%d: %s,focused\n", ++iconIndex, icon);
                }
                if (iconIndex > 0) {
                    out.printf("RIM-MIDlet-Icon-Count-1: %d\n", iconIndex);
                }
                int flags = 0;
                if (this.runOnStartup) {
                    flags |= 225 - (2 * this.startupTier << 4);
                }
                if (this.systemModule) {
                    flags |= 2;
                }
                out.printf("RIM-MIDlet-Flags-1: %d\n", flags);
                if (this.entryPoints.size() != 0) {
                    int entryIndex = 2;
                    for (EntryPointType entryPoint : this.entryPoints) {
                        if (!entryPoint.enabled(this.getProject())) continue;
                        out.printf("MIDlet-%d: %s,%s,%s\n", entryIndex, entryPoint.getTitle(), entryPoint.getFirstIcon(), entryPoint.getArguments());
                        if (entryPoint.getRibbonPosition() > 0) {
                            out.printf("RIM-MIDlet-Position-%d: %d\n", entryIndex, entryPoint.getRibbonPosition());
                        }
                        if (entryPoint.getNameResourceBundle() != null && entryPoint.getNameResourceId() > -1) {
                            out.printf("RIM-MIDlet-NameResourceBundle-%d: %s\n", entryIndex, entryPoint.getNameResourceBundle());
                            out.printf("RIM-MIDlet-NameResourceId-%d: %d\n", entryIndex, entryPoint.getNameResourceId());
                        }
                        iconIndex = 0;
                        for (int i = 1; i < entryPoint.icons.length; ++i) {
                            out.printf("RIM-MIDlet-Icon-%d-%d: %s\n", entryIndex, ++iconIndex, entryPoint.icons[i]);
                        }
                        for (String icon : entryPoint.focusIcons) {
                            out.printf("RIM-MIDlet-Icon-%d-%d: %s,focused\n", entryIndex, ++iconIndex, icon);
                        }
                        if (iconIndex > 0) {
                            out.printf("RIM-MIDlet-Icon-Count-%d: %d\n", entryIndex, iconIndex);
                        }
                        flags = 0;
                        if (entryPoint.isRunOnStartup()) {
                            flags |= 225 - (2 * entryPoint.getStartupTier() << 4);
                        }
                        if (entryPoint.isSystemModule()) {
                            flags |= 2;
                        }
                        out.printf("RIM-MIDlet-Flags-%d: %d\n", entryIndex, flags);
                        ++entryIndex;
                    }
                }
            } else if ("midlet".equals(this.type.getValue())) {
                out.printf("MIDlet-1: %s,%s,%s\n", this.title, this.getFirstIcon(), this.midletClass);
                if (this.ribbonPosition > 0) {
                    out.printf("RIM-MIDlet-Position-1: %d\n", this.ribbonPosition);
                }
                int flags = 224;
                if (this.systemModule) {
                    flags |= 2;
                }
                out.printf("RIM-MIDlet-Flags-1: %d\n", flags);
            } else {
                int flags = 2;
                if (this.runOnStartup) {
                    flags |= 225 - (2 * this.startupTier << 4);
                }
                out.printf("RIM-Library-Flags: %d\n", flags);
            }
        }
        catch (IOException e) {
            throw new BuildException("error creating manifest", (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

