/*
 * Decompiled with CFR 0.152.
 */
package ca.slashdev.bb.types;

import ca.slashdev.bb.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;

public class BaseJdpType
extends DataType {
    protected String title = "";
    protected String arguments = "";
    protected boolean systemModule;
    protected boolean runOnStartup;
    protected int startupTier = 7;
    protected int ribbonPosition = 0;
    protected String nameResourceBundle;
    protected int nameResourceId = -1;
    protected String[] icons = new String[0];
    protected String[] focusIcons = new String[0];

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public int getRibbonPosition() {
        return this.ribbonPosition;
    }

    public void setRibbonPosition(int ribbonPosition) {
        this.ribbonPosition = ribbonPosition;
    }

    public boolean isRunOnStartup() {
        return this.runOnStartup;
    }

    public void setRunOnStartup(boolean runOnStartup) {
        this.runOnStartup = runOnStartup;
    }

    public int getStartupTier() {
        return this.startupTier;
    }

    public void setStartupTier(int startupTier) {
        this.startupTier = startupTier;
    }

    public boolean isSystemModule() {
        return this.systemModule;
    }

    public void setSystemModule(boolean systemModule) {
        this.systemModule = systemModule;
    }

    public String getNameResourceBundle() {
        return this.nameResourceBundle;
    }

    public void setNameResourceBundle(String nameResourceBundle) {
        this.nameResourceBundle = nameResourceBundle;
    }

    public int getNameResourceId() {
        return this.nameResourceId;
    }

    public void setNameResourceId(int nameResourceId) {
        this.nameResourceId = nameResourceId;
    }

    public String getIcon() {
        return Utils.join(this.icons);
    }

    public void setIcon(String icon) {
        this.icons = icon != null && icon.length() > 0 ? icon.split(",") : new String[]{};
    }

    public String getFocusIcon() {
        return Utils.join(this.focusIcons);
    }

    public void setFocusIcon(String focusIcon) {
        this.focusIcons = focusIcon != null && focusIcon.length() > 0 ? focusIcon.split(",") : new String[]{};
    }

    protected String getFirstIcon() {
        return this.icons.length > 0 ? this.icons[0] : "";
    }

    public void setFile(File file) throws BuildException {
        FileInputStream in = null;
        if (!file.isFile()) {
            throw new BuildException("file attribute must be a properties file");
        }
        try {
            in = new FileInputStream(file);
            Properties props = new Properties();
            props.load(in);
            this.title = props.getProperty("title", "");
            this.arguments = props.getProperty("arguments", "");
            this.systemModule = Boolean.parseBoolean(props.getProperty("systemmodule", "false"));
            this.runOnStartup = Boolean.parseBoolean(props.getProperty("runonstartup", "false"));
            this.setStartupTier(Integer.parseInt(props.getProperty("startupTier", "7")));
            this.ribbonPosition = Integer.parseInt(props.getProperty("ribbonposition", "0"));
            this.nameResourceBundle = props.getProperty("nameresourcebundle");
            this.nameResourceId = Integer.parseInt(props.getProperty("nameresourceid", "-1"));
            this.setIcon(props.getProperty("icon", null));
            this.setFocusIcon(props.getProperty("focusIcon", null));
        }
        catch (IOException e) {
            throw new BuildException("error loading properties", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

