/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna;

import de.pleumann.antenna.misc.Conditional;
import de.pleumann.antenna.misc.JadFile;
import de.pleumann.antenna.misc.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WtkDeploy
extends Task {
    private File jarFile;
    private File jadFile;
    private String target;
    private boolean delete;
    private String login;
    private String password;
    private Conditional condition;

    public void init() throws BuildException {
        super.init();
        this.condition = new Conditional(this.getProject());
    }

    public void setJarfile(File file) {
        this.jarFile = file;
    }

    public void setJadfile(File file) {
        this.jadFile = file;
    }

    public void setTarget(String s) {
        this.target = s;
    }

    public void setDelete(boolean b) {
        this.delete = b;
    }

    public void setLogin(String s) {
        this.login = s;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public void setIf(String s) {
        this.condition.setIf(s);
    }

    public void setUnless(String s) {
        this.condition.setUnless(s);
    }

    public boolean isActive() {
        return this.condition.isActive();
    }

    public void execute() throws BuildException {
        if (!this.isActive()) {
            return;
        }
        try {
            if (this.jarFile == null || !this.jarFile.exists()) {
                throw new IllegalArgumentException("Need a JAR file.");
            }
            if (this.jadFile == null || !this.jadFile.exists()) {
                throw new IllegalArgumentException("Need a JAD file.");
            }
            if (this.target == null) {
                JadFile jad = new JadFile();
                jad.load(this.jadFile.getAbsolutePath(), null);
                String s = jad.getValue("MIDlet-Jar-URL");
                if (s != null && s.startsWith("http://")) {
                    int p = s.lastIndexOf(47);
                    this.target = s.substring(0, p);
                }
            }
            if (this.target == null) {
                throw new IllegalArgumentException("Need a deployment target.");
            }
            this.log("Deploying to " + this.target + "...");
            this.upload(this.jarFile);
            this.upload(this.jadFile);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void upload(File file) throws IOException {
        this.log((this.delete ? "Deleting" : "Uploading") + " file " + file.getName());
        String s = this.target + "/" + file.getName() + "?delete=" + this.delete;
        if (this.login != null) {
            s = s + "&login=" + this.login;
        }
        if (this.password != null) {
            s = s + "&password=" + this.password;
        }
        URL url = new URL(s);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.connect();
        if (!this.delete) {
            FileInputStream input = new FileInputStream(file);
            OutputStream output = connection.getOutputStream();
            Utility.copyStreams(input, output);
            output.flush();
            output.close();
        }
        int i = connection.getResponseCode();
        String message = connection.getResponseMessage() + " (" + i + ")";
        this.log(message, 3);
        if (i >= 300) {
            throw new IOException(message);
        }
    }
}

