/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.FieldOptimizationInfo;

public class ReadWriteFieldMarker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private boolean reading = true;
    private boolean writing = true;

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        byte by = constantInstruction.opcode;
        switch (by) {
            case 18: 
            case 19: {
                this.reading = true;
                this.writing = true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -78: 
            case -76: {
                this.reading = true;
                this.writing = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -77: 
            case -75: {
                this.reading = false;
                this.writing = true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            }
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.referencedMemberAccept(this);
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        fieldrefConstant.referencedMemberAccept(this);
    }

    public void visitAnyMember(Clazz clazz, Member member) {
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.reading) {
            ReadWriteFieldMarker.markAsRead(programField);
        }
        if (this.writing) {
            ReadWriteFieldMarker.markAsWritten(programField);
        }
    }

    private static void markAsRead(Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        if (fieldOptimizationInfo != null) {
            fieldOptimizationInfo.setRead();
        }
    }

    public static boolean isRead(Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        return fieldOptimizationInfo == null || fieldOptimizationInfo.isRead();
    }

    private static void markAsWritten(Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        if (fieldOptimizationInfo != null) {
            fieldOptimizationInfo.setWritten();
        }
    }

    public static boolean isWritten(Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        return fieldOptimizationInfo == null || fieldOptimizationInfo.isWritten();
    }
}

