/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.ConstantValueFactory;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.SpecificValueFactory;
import proguard.evaluation.value.Value;

public class FieldOptimizationInfo
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final SpecificValueFactory VALUE_FACTORY = new SpecificValueFactory();
    private static final ConstantValueFactory CONSTANT_VALUE_FACTORY = new ConstantValueFactory(VALUE_FACTORY);
    private boolean isWritten;
    private boolean isRead;
    private boolean canBeMadePrivate = true;
    private ReferenceValue referencedClass;
    private Value value;

    public FieldOptimizationInfo(Clazz clazz, Field field) {
        int n = field.getAccessFlags();
        this.isRead = (n & 0x40) != 0;
        this.isWritten = this.isRead;
        if ((n & 8) != 0) {
            field.accept(clazz, new AllAttributeVisitor(this));
        }
        if ((n & 0x10) == 0 && this.value == null) {
            this.value = this.initialValue(field.getDescriptor(clazz));
        }
    }

    public void setWritten() {
        this.isWritten = true;
    }

    public boolean isWritten() {
        return this.isWritten;
    }

    public void setRead() {
        this.isRead = true;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public void setCanNotBeMadePrivate() {
        this.canBeMadePrivate = false;
    }

    public boolean canBeMadePrivate() {
        return this.canBeMadePrivate;
    }

    public void generalizeReferencedClass(ReferenceValue referenceValue) {
        this.referencedClass = this.referencedClass != null ? this.referencedClass.generalize(referenceValue) : referenceValue;
    }

    public ReferenceValue getReferencedClass() {
        return this.referencedClass;
    }

    public void generalizeValue(Value value) {
        this.value = this.value != null ? this.value.generalize(value) : value;
    }

    public Value getValue() {
        return this.value;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        this.value = CONSTANT_VALUE_FACTORY.constantValue(clazz, constantValueAttribute.u2constantValueIndex);
    }

    private Value initialValue(String string) {
        switch (string.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return VALUE_FACTORY.createIntegerValue(0);
            }
            case 'J': {
                return VALUE_FACTORY.createLongValue(0L);
            }
            case 'F': {
                return VALUE_FACTORY.createFloatValue(0.0f);
            }
            case 'D': {
                return VALUE_FACTORY.createDoubleValue(0.0);
            }
            case 'L': 
            case '[': {
                return VALUE_FACTORY.createReferenceValueNull();
            }
        }
        throw new IllegalArgumentException("Invalid type [" + string + "]");
    }

    public static void setFieldOptimizationInfo(Clazz clazz, Field field) {
        field.setVisitorInfo(new FieldOptimizationInfo(clazz, field));
    }

    public static FieldOptimizationInfo getFieldOptimizationInfo(Field field) {
        Object object = field.getVisitorInfo();
        return object instanceof FieldOptimizationInfo ? (FieldOptimizationInfo)object : null;
    }
}

