/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.codecs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.nio.codecs.AbstractContentEncoder;
import org.apache.http.nio.FileContentEncoder;
import org.apache.http.nio.reactor.SessionOutputBuffer;

public class LengthDelimitedEncoder
extends AbstractContentEncoder
implements FileContentEncoder {
    private final long contentLength;
    private long len;

    public LengthDelimitedEncoder(WritableByteChannel channel, SessionOutputBuffer buffer, HttpTransportMetricsImpl metrics, long contentLength) {
        super(channel, buffer, metrics);
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length may not be negative");
        }
        this.contentLength = contentLength;
        this.len = 0L;
    }

    public int write(ByteBuffer src) throws IOException {
        int bytesWritten;
        if (src == null) {
            return 0;
        }
        this.assertNotCompleted();
        int lenRemaining = (int)(this.contentLength - this.len);
        if (src.remaining() > lenRemaining) {
            int oldLimit = src.limit();
            int newLimit = oldLimit - (src.remaining() - lenRemaining);
            src.limit(newLimit);
            bytesWritten = this.channel.write(src);
            src.limit(oldLimit);
        } else {
            bytesWritten = this.channel.write(src);
        }
        if (bytesWritten > 0) {
            this.metrics.incrementBytesTransferred((long)bytesWritten);
        }
        this.len += (long)bytesWritten;
        if (this.len >= this.contentLength) {
            this.completed = true;
        }
        return bytesWritten;
    }

    public long transfer(FileChannel src, long position, long count) throws IOException {
        long bytesWritten;
        if (src == null) {
            return 0L;
        }
        this.assertNotCompleted();
        int lenRemaining = (int)(this.contentLength - this.len);
        if (count > (long)lenRemaining) {
            count = lenRemaining;
        }
        if ((bytesWritten = src.transferTo(position, count, this.channel)) > 0L) {
            this.metrics.incrementBytesTransferred(bytesWritten);
        }
        this.len += bytesWritten;
        if (this.len >= this.contentLength) {
            this.completed = true;
        }
        return bytesWritten;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[content length: ");
        buffer.append(this.contentLength);
        buffer.append("; pos: ");
        buffer.append(this.len);
        buffer.append("; completed: ");
        buffer.append(this.completed);
        buffer.append("]");
        return buffer.toString();
    }
}

