/*
 * Decompiled with CFR 0.152.
 */
package jphase.generator;

import java.util.Random;
import jphase.PhaseVar;
import no.uib.cipr.matrix.Vector;

public class GeneratorUtils {
    static final double precision = 1.0E-4;

    public static int argmin(double[] data) {
        int index = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] < data[index]) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int argmax(double[] data) {
        int index = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] > data[index]) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static double sum(double[] data) {
        double sum = 0.0;
        int i = 0;
        while (i < data.length) {
            sum += data[i];
            ++i;
        }
        return sum;
    }

    public static double sumAbs(double[] data) {
        double sum = 0.0;
        int i = 0;
        while (i < data.length) {
            sum += Math.abs(data[i]);
            ++i;
        }
        return sum;
    }

    public static void aliasCut(Vector dist, int[] alias, double[] cutoff) {
        int n = dist.size();
        double[] dist2 = new double[n + 1];
        int i = 0;
        while (i < n) {
            dist2[i + 1] = dist.get(i);
            ++i;
        }
        dist2[0] = GeneratorUtils.sum(dist2);
        GeneratorUtils.aliasCut(dist2, alias, cutoff);
    }

    public static void aliasCut(double[] dist, int[] alias, double[] cutoff) {
        if (dist.length == alias.length && alias.length == cutoff.length) {
            int n = dist.length;
            double[] b = new double[n];
            int i = 0;
            i = 0;
            while (i < n) {
                alias[i] = i;
                cutoff[i] = 0.0;
                b[i] = dist[i] - 1.0 / new Integer(n).doubleValue();
                ++i;
            }
            double d = 0.0;
            int m = 0;
            boolean ready = false;
            i = 0;
            while (i < n && !ready) {
                int k = GeneratorUtils.argmin(b);
                double c = b[k];
                m = GeneratorUtils.argmax(b);
                d = b[m];
                alias[k] = m;
                cutoff[k] = 1.0 + c * (double)n;
                b[k] = 0.0;
                b[m] = c + d;
                if (GeneratorUtils.sumAbs(b) < 1.0E-4) {
                    ready = true;
                }
                ++i;
            }
        }
    }

    public static int getNumber(double[] dist, int[] alias, double[] cutoff, Random rand) {
        int entero;
        double u1 = rand.nextDouble();
        double u2 = rand.nextDouble();
        return u2 < cutoff[entero = new Double(Math.floor((double)dist.length * u1)).intValue()] ? entero : alias[entero];
    }

    public static double erlang(double lambda, int r, Random rand) {
        if (r > 0) {
            double x = rand.nextDouble();
            int i = 1;
            while (i < r) {
                x *= rand.nextDouble();
                ++i;
            }
            return -(1.0 / lambda) * Math.log(x);
        }
        return 0.0;
    }

    public static double algorKS(double[] data, PhaseVar var) {
        double Kmax = 0.0;
        int n = data.length;
        int[] NUM = new int[n + 1];
        double[] MAX = new double[n + 1];
        double[] MIN = new double[n + 1];
        int i = 0;
        while (i < n + 1) {
            MIN[i] = 1.0;
            MAX[i] = 0.0;
            NUM[i] = 0;
            ++i;
        }
        i = 0;
        while (i < n) {
            int jd;
            double f = var.cdf(data[i]);
            double j = Math.ceil(f * (double)n);
            int n2 = jd = new Double(j).intValue();
            NUM[n2] = NUM[n2] + 1;
            if (MAX[jd] < f) {
                MAX[jd] = f;
            }
            if (MIN[jd] > f) {
                MIN[jd] = f;
            }
            ++i;
        }
        double j = 0.0;
        double DP = 0.0;
        double DN = 0.0;
        int i2 = 0;
        while (i2 < n + 1) {
            if (NUM[i2] > 0) {
                double z = MIN[i2] - j / (double)n;
                if (z > DN) {
                    DN = z;
                }
                if ((z = (j += (double)NUM[i2]) / (double)n - MAX[i2]) > DP) {
                    DP = z;
                }
            }
            ++i2;
        }
        Kmax = Math.max(DP, DN);
        return Kmax;
    }
}

