/*
 * Decompiled with CFR 0.152.
 */
package jphase.fit;

import java.util.Arrays;
import jphase.DenseContPhaseVar;
import jphase.MatrixUtils;
import jphase.fit.MLContPhaseFitter;
import jphase.fit.Solution;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class EMPhaseFit
extends MLContPhaseFitter {
    public static double precision = 1.0E-5;
    public static double logPrecision = 1.0E-4;
    public static double precisionParam = 1.0E-5;
    public static int evalPoints = 10;
    private DenseMatrix A;
    private DenseVector alpha;
    private DenseVector t;
    private int n;

    public EMPhaseFit(double[] data) {
        super(data);
    }

    @Override
    public DenseContPhaseVar fit() {
        int N = 5;
        int best = 0;
        double[] LH = new double[N];
        DenseContPhaseVar[] vars = new DenseContPhaseVar[N];
        int k = 0;
        while (k < N) {
            System.out.println("\n\nITERATION: " + (k + 1));
            System.out.println("N: " + (k + 1));
            this.n = k + 1;
            vars[k] = new DenseContPhaseVar(k + 1);
            LH[k] = this.doFitN(this.data);
            vars[k] = new DenseContPhaseVar(this.alpha, this.A);
            System.out.println("Variable: " + vars[k].toString());
            System.out.println("Likelihood:\t" + LH[k]);
            System.out.println("Mean:\t" + vars[k].expectedValue());
            System.out.println("Variance:\t" + vars[k].variance());
            System.out.println("CV:\t" + vars[k].CV());
            if (LH[k] > LH[best]) {
                best = k;
            }
            ++k;
        }
        System.out.println("The best variable found is: " + vars[best].toString());
        System.out.println("Likelihood: " + LH[best]);
        return vars[best];
    }

    public double doFitN(double[] data) {
        Arrays.sort(data);
        this.A = new DenseMatrix(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            double temp = 0.0;
            int j = 0;
            while (j < this.n) {
                if (j != i) {
                    this.A.set(i, j, Math.pow(10.0, -j));
                }
                temp += Math.pow(10.0, -j);
                ++j;
            }
            this.A.set(i, i, -temp);
            ++i;
        }
        this.alpha = new DenseVector(this.n);
        i = 0;
        while (i < this.n) {
            this.alpha.set(i, ((double)i + 1.0) / (double)(this.n * this.n));
            ++i;
        }
        this.t = (DenseVector)this.A.copy().mult((Vector)MatrixUtils.OnesVector(this.A.numColumns()), (Vector)new DenseVector(this.alpha.size())).scale(-1.0);
        int iter = 0;
        int maxIter = 10;
        boolean ready = false;
        DenseVector B = new DenseVector(this.n);
        DenseVector Z = new DenseVector(this.n);
        DenseMatrix N = new DenseMatrix(this.n, this.n + 1);
        double LHold = 0.0;
        double LHnew = 0.0;
        double logLHold = 0.0;
        double logLHnew = 0.0;
        while (!ready) {
            ++iter;
            DenseMatrix newA = this.A.copy();
            DenseVector newAlpha = this.alpha.copy();
            DenseVector newT = this.t.copy();
            this.eStep(data, B, Z, N, newA, newAlpha, newT);
            LHold = LHnew;
            LHnew = this.mStep(data.length, B, Z, N, newA, newAlpha, newT);
            logLHold = logLHnew;
            logLHnew = 0.0;
            DenseContPhaseVar var = new DenseContPhaseVar(newAlpha, newA);
            int v = 0;
            while (v < data.length) {
                logLHnew += Math.log(var.pdf(data[v]));
                ++v;
            }
            int i2 = 0;
            while (i2 < this.n) {
                System.out.print(String.valueOf(B.get(i2)) + "\t");
                ++i2;
            }
            System.out.println();
            Matrix difMat = this.A.copy().add(-1.0, (Matrix)newA);
            double dif = Math.abs(difMat.norm(Matrix.Norm.Maxvalue));
            this.A.set((Matrix)newA);
            this.alpha.set((Vector)newAlpha);
            this.t.set((Vector)newT);
            if (!(dif < logPrecision) && iter <= maxIter) continue;
            ready = true;
        }
        return logLHnew;
    }

    /*
     * Unable to fully structure code
     */
    private void eStep(double[] data, DenseVector B, DenseVector Z, DenseMatrix N, DenseMatrix newA, DenseVector newAlpha, DenseVector newT) {
        min = data[0];
        max = data[data.length - 1];
        points = data.length * EMPhaseFit.evalPoints;
        step = (max - min) / (double)points;
        c = new DenseVector[this.n];
        i = 0;
        while (i < this.n) {
            c[i] = this.t.copy().zero();
            ++i;
        }
        res = this.RungeKutta(step, min, max, newAlpha.copy(), newT.copy(), c);
        eval = new Solution[data.length];
        k = 0;
        i = 0;
        ** GOTO lbl38
        {
            ++k;
            do {
                if (res[k].t < data[i] && k < points - 1) continue block1;
                if (k == 0) {
                    eval[i] = new Solution(data[i], res[k].a.copy(), res[k].b.copy(), res[k].c);
                } else if (res[k].t < data[i] && k == points - 1) {
                    eval[i] = new Solution(data[i], res[res.length - 1].a.copy(), res[res.length - 1].b.copy(), res[res.length - 1].c);
                } else {
                    tTemp = data[i];
                    pondA = (data[i] - res[k - 1].t) / step;
                    pondB = (res[k].t - data[i]) / step;
                    aTemp = (DenseVector)res[k - 1].a.copy().scale(pondA).add(pondB, (Vector)res[k].a.copy());
                    bTemp = (DenseVector)res[k - 1].b.copy().scale(pondA).add(pondB, (Vector)res[k].b.copy());
                    cTemp = new DenseVector[this.n];
                    j = 0;
                    while (j < this.n) {
                        cTemp[j] = (DenseVector)res[k - 1].c[j].copy().scale(pondA).add(pondB, (Vector)res[k].c[j].copy());
                        ++j;
                    }
                    eval[i] = new Solution(tTemp, aTemp, bTemp, cTemp);
                }
                ++i;
lbl38:
                // 2 sources

            } while (i < data.length);
        }
        Biv = new double[this.n][data.length];
        Ziv = new double[this.n][data.length];
        Nijv = new double[this.n][this.n][data.length];
        Ni0v = new double[this.n][data.length];
        v = 0;
        while (v < data.length) {
            denom = newAlpha.dot((Vector)eval[v].b);
            i = 0;
            while (i < this.n) {
                Biv[i][v] = newAlpha.get(i) * eval[v].b.get(i) / denom;
                Ziv[i][v] = eval[v].c[i].get(i) / denom;
                Ni0v[i][v] = newT.get(i) * eval[v].a.get(i) / denom;
                j = 0;
                while (j < this.n) {
                    if (i != j) {
                        Nijv[i][j][v] = newA.get(i, j) * eval[v].c[i].get(j) / denom;
                    }
                    ++j;
                }
                ++i;
            }
            ++v;
        }
        i = 0;
        while (i < this.n) {
            temp = 0.0;
            v = 0;
            while (v < data.length) {
                temp += Biv[i][v];
                ++v;
            }
            temp = Math.abs(temp) < EMPhaseFit.precisionParam ? 0.0 : temp;
            B.set(i, temp);
            temp = 0.0;
            v = 0;
            while (v < data.length) {
                temp += Ziv[i][v];
                ++v;
            }
            temp = Math.abs(temp) < EMPhaseFit.precisionParam ? 0.0 : temp;
            Z.set(i, temp);
            temp = 0.0;
            v = 0;
            while (v < data.length) {
                temp += Ni0v[i][v];
                ++v;
            }
            temp = Math.abs(temp) < EMPhaseFit.precisionParam ? 0.0 : temp;
            N.set(i, 0, temp);
            j = 0;
            while (j < this.n) {
                if (i != j) {
                    temp = 0.0;
                    v = 0;
                    while (v < data.length) {
                        temp += Nijv[i][j][v];
                        ++v;
                    }
                    temp = Math.abs(temp) < EMPhaseFit.precisionParam ? 0.0 : temp;
                    N.set(i, j + 1, temp);
                }
                ++j;
            }
            ++i;
        }
    }

    private double mStep(int n, DenseVector B, DenseVector Z, DenseMatrix N, DenseMatrix newA, DenseVector newAlpha, DenseVector newT) {
        int j;
        int p = B.size();
        int i = 0;
        while (i < p) {
            newAlpha.set(i, B.get(i) / (double)n);
            ++i;
        }
        i = 0;
        while (i < p) {
            if (Z.get(i) != 0.0) {
                newT.set(i, N.get(i, 0) / Z.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < p) {
            int j2 = 1;
            while (j2 < p + 1) {
                if (i + 1 != j2 && Z.get(i) != 0.0) {
                    newA.set(i, j2 - 1, N.get(i, j2) / Z.get(i));
                }
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < p) {
            double temp = -newT.get(i);
            j = 0;
            while (j < p) {
                if (i != j) {
                    temp -= newA.get(i, j);
                }
                ++j;
            }
            newA.set(i, i, temp);
            ++i;
        }
        double LH = 0.0;
        int i2 = 0;
        while (i2 < this.n) {
            j = 1;
            while (j < this.n + 1) {
                if (i2 + 1 != j && newA.get(i2, j - 1) > precision) {
                    LH += N.get(i2, j) * Math.log(newA.get(i2, j - 1));
                }
                ++j;
            }
            if (newT.get(i2) > precision) {
                LH += N.get(i2, 0) * Math.log(newT.get(i2));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.n) {
            LH += newA.get(i2, i2) * Z.get(i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.n) {
            if (newAlpha.get(i2) > precision) {
                LH += B.get(i2) * Math.log(newAlpha.get(i2));
            }
            ++i2;
        }
        return LH;
    }

    private Solution[] RungeKutta(double step, double ini, double fin, DenseVector a0, DenseVector b0, DenseVector[] c0) {
        int N = (int)Math.round((fin - ini) / step);
        Solution[] res = new Solution[N + 1];
        double t = ini;
        DenseVector a = a0.copy();
        DenseVector b = b0.copy();
        DenseVector[] c = new DenseVector[c0.length];
        this.copiarVector(c0, c, c0.length);
        res[0] = new Solution(t, a, b, c);
        DenseVector[] K1c = new DenseVector[this.n];
        DenseVector[] K2c = new DenseVector[this.n];
        DenseVector[] K3c = new DenseVector[this.n];
        DenseVector[] K4c = new DenseVector[this.n];
        int i = 1;
        while (i <= N) {
            DenseVector aTemp = a.copy();
            DenseVector bTemp = b.copy();
            DenseVector[] cTemp = new DenseVector[c.length];
            this.copiarVector(c, cTemp, c.length);
            this.function(aTemp, bTemp, cTemp);
            DenseVector K1a = aTemp.copy().scale(step);
            DenseVector K1b = bTemp.copy().scale(step);
            int j = 0;
            while (j < this.n) {
                K1c[j] = cTemp[j].copy().scale(step);
                ++j;
            }
            aTemp = (DenseVector)a.copy().add(0.5, (Vector)K1a);
            bTemp = (DenseVector)b.copy().add(0.5, (Vector)K1b);
            cTemp = new DenseVector[c.length];
            this.copiarVector(c, cTemp, c.length);
            j = 0;
            while (j < this.n) {
                cTemp[j] = (DenseVector)c[j].copy().add(0.5, (Vector)K1c[j]);
                ++j;
            }
            this.function(aTemp, bTemp, cTemp);
            DenseVector K2a = aTemp.copy().scale(step);
            DenseVector K2b = bTemp.copy().scale(step);
            j = 0;
            while (j < this.n) {
                K2c[j] = cTemp[j].copy().scale(step);
                ++j;
            }
            aTemp = (DenseVector)a.copy().add(0.5, (Vector)K2a);
            bTemp = (DenseVector)b.copy().add(0.5, (Vector)K2b);
            cTemp = new DenseVector[c.length];
            this.copiarVector(c, cTemp, c.length);
            j = 0;
            while (j < this.n) {
                cTemp[j] = (DenseVector)c[j].copy().add(0.5, (Vector)K2c[j]);
                ++j;
            }
            this.function(aTemp, bTemp, cTemp);
            DenseVector K3a = aTemp.copy().scale(step);
            DenseVector K3b = bTemp.copy().scale(step);
            j = 0;
            while (j < this.n) {
                K3c[j] = cTemp[j].copy().scale(step);
                ++j;
            }
            aTemp = (DenseVector)a.copy().add((Vector)K3a);
            bTemp = (DenseVector)b.copy().add((Vector)K3b);
            cTemp = new DenseVector[c.length];
            this.copiarVector(c, cTemp, c.length);
            j = 0;
            while (j < this.n) {
                cTemp[j] = (DenseVector)c[j].copy().add((Vector)K3c[j]);
                ++j;
            }
            this.function(aTemp, bTemp, cTemp);
            DenseVector K4a = aTemp.copy().scale(step);
            DenseVector K4b = bTemp.copy().scale(step);
            j = 0;
            while (j < this.n) {
                K4c[j] = cTemp[j].copy().scale(step);
                ++j;
            }
            a = (DenseVector)a.add(0.16666666666666666, (Vector)K1a).add(0.3333333333333333, (Vector)K2a).add(0.3333333333333333, (Vector)K3a).add(0.16666666666666666, (Vector)K4a);
            b = (DenseVector)b.add(0.16666666666666666, (Vector)K1b).add(0.3333333333333333, (Vector)K2b).add(0.3333333333333333, (Vector)K3b).add(0.16666666666666666, (Vector)K4b);
            j = 0;
            while (j < this.n) {
                c[j] = (DenseVector)c[j].add(0.16666666666666666, (Vector)K1c[j]).add(0.3333333333333333, (Vector)K2c[j]).add(0.3333333333333333, (Vector)K3c[j]).add(0.16666666666666666, (Vector)K4c[j]);
                ++j;
            }
            t = ini + (double)i * step;
            res[i] = new Solution(t, a, b, c);
            ++i;
        }
        return res;
    }

    private void copiarVector(DenseVector[] c0, DenseVector[] c, int length) {
        int k = 0;
        while (k < length) {
            c[k] = c0[k].copy();
            ++k;
        }
    }

    private void function(DenseVector a, DenseVector b, DenseVector[] c) {
        int i = 0;
        while (i < this.n) {
            c[i].set(this.A.copy().mult((Vector)c[i].copy(), (Vector)c[i].copy().zero()).add(a.get(i), (Vector)this.t.copy()));
            int j = 0;
            while (j < this.n) {
                if (Math.abs(c[i].get(j)) < precisionParam) {
                    c[i].set(j, 0.0);
                }
                ++j;
            }
            ++i;
        }
        a.set(this.A.copy().transMult((Vector)a.copy(), (Vector)a.copy().zero()));
        int j = 0;
        while (j < this.n) {
            if (Math.abs(a.get(j)) < precisionParam) {
                a.set(j, 0.0);
            }
            ++j;
        }
        b.set(this.A.copy().mult((Vector)b.copy(), (Vector)b.copy().zero()));
        j = 0;
        while (j < this.n) {
            if (Math.abs(b.get(j)) < precisionParam) {
                b.set(j, 0.0);
            }
            ++j;
        }
    }
}

