/*
 * Decompiled with CFR 0.152.
 */
package jphase.fit;

import jphase.DenseContPhaseVar;
import jphase.fit.MLContPhaseFitter;

public class EMHyperExpoFit
extends MLContPhaseFitter {
    public static double precision = 1.0E-4;
    public static double precisionParam = 0.01;
    private int n;
    private double[] probs;
    private double[] rates;

    public EMHyperExpoFit(double[] data) {
        super(data);
    }

    @Override
    public DenseContPhaseVar fit() {
        int N = 15;
        int best = 0;
        double[] LH = new double[N];
        DenseContPhaseVar[] vars = new DenseContPhaseVar[N];
        int k = 0;
        while (k < N) {
            System.out.println("\n\nITERATION: " + (k + 1));
            System.out.println("N: " + (k + 1));
            this.n = k + 1;
            vars[k] = new DenseContPhaseVar(k + 1);
            LH[k] = this.doFitN(this.data);
            vars[k] = DenseContPhaseVar.HyperExpo(this.rates, this.probs);
            System.out.println("Likelihood: " + LH[k]);
            System.out.println("Mean: " + vars[k].expectedValue());
            System.out.println("Variance: " + vars[k].variance());
            System.out.println("CV: " + vars[k].CV());
            if (LH[k] > LH[best]) {
                best = k;
            }
            ++k;
        }
        System.out.println("The best variable found is: " + vars[best].toString());
        System.out.println("Likelihood: " + LH[best]);
        return vars[best];
    }

    public double doFitN(double[] data) {
        this.probs = new double[this.n];
        this.rates = new double[this.n];
        int i = 0;
        while (i < this.n) {
            this.probs[i] = 1.0 / (double)this.n;
            this.probs[i] = 0.9 * Math.pow(10.0, -i) / (1.0 - Math.pow(10.0, -this.n));
            this.rates[i] = Math.pow(10.0, -i + 1);
            ++i;
        }
        int iter = 0;
        int maxIter = 300;
        boolean ready = false;
        double[][] p = new double[data.length][this.n];
        double LHold = 0.0;
        double LHnew = 0.0;
        while (!ready) {
            this.eStep(data, p);
            LHold = LHnew;
            LHnew = this.mStep(data, p);
            double dif = Math.abs(LHold - LHnew);
            if (!(dif < precision) && ++iter <= maxIter) continue;
            ready = true;
        }
        return LHnew;
    }

    private void eStep(double[] data, double[][] p) {
        int n = 0;
        while (n < data.length) {
            double denom = 0.0;
            int i = 0;
            while (i < this.n) {
                double num;
                p[n][i] = num = this.probs[i] * this.rates[i] * Math.exp(-this.rates[i] * data[n]);
                denom += num;
                ++i;
            }
            i = 0;
            while (i < this.n) {
                double[] dArray = p[n];
                int n2 = i++;
                dArray[n2] = dArray[n2] / denom;
            }
            ++n;
        }
    }

    private double mStep(double[] data, double[][] p) {
        int N = data.length;
        int i = 0;
        while (i < this.n) {
            double sum = 0.0;
            double sumX = 0.0;
            int n = 0;
            while (n < N) {
                sum += p[n][i];
                sumX += p[n][i] * data[n];
                ++n;
            }
            this.probs[i] = sum / (double)N;
            this.rates[i] = sum / sumX;
            ++i;
        }
        double LH = 0.0;
        int n = 0;
        while (n < N) {
            double sumLH = 0.0;
            int i2 = 0;
            while (i2 < this.n) {
                sumLH += this.probs[i2] * this.rates[i2] * Math.exp(-this.rates[i2] * data[n]);
                ++i2;
            }
            LH += Math.log(sumLH);
            ++n;
        }
        return LH;
    }
}

