/*
 * Decompiled with CFR 0.152.
 */
package jphase.fit;

import jphase.DenseContPhaseVar;
import jphase.PhaseVar;
import jphase.fit.MomentsECCompleteFit;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class ECCompleteFitTest
extends TestCase {
    double m1;
    double m2;
    double m3;
    MomentsECCompleteFit fitter;
    PhaseVar calcVar;

    public static void main(String[] args) {
        TestRunner.run(ECCompleteFitTest.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testParamCaso1() {
        this.m1 = 1.0;
        this.m2 = 2.0;
        this.m3 = 8.0;
        this.fitter = new MomentsECCompleteFit(this.m1, this.m2, this.m3);
        this.calcVar = this.fitter.fit();
        double[] vecRes = new double[]{0.875, 0.0, 0.0};
        double[][] matRes = new double[][]{{-1.1667, 1.1667, 0.0}, {0.0, -3.6904, 0.0093}, {0.0, 0.0, -0.1717}};
        DenseContPhaseVar realVar = new DenseContPhaseVar(vecRes, matRes);
        ECCompleteFitTest.assertTrue((String)"Variable not well fitted from moments (Matrix)", (realVar.getMatrix().add(-1.0, this.calcVar.getMatrix()).norm(Matrix.Norm.Maxvalue) < 0.001 ? 1 : 0) != 0);
        ECCompleteFitTest.assertTrue((String)"Variable not well fitted from moments (Vector)", (realVar.getVector().add(-1.0, this.calcVar.getVector()).norm(Vector.Norm.Infinity) < 0.001 ? 1 : 0) != 0);
    }

    public void testParamCaso2() {
        this.m1 = 1.0;
        this.m2 = 2.0;
        this.m3 = 5.0;
        this.fitter = new MomentsECCompleteFit(this.m1, this.m2, this.m3);
        this.calcVar = this.fitter.fit();
        double[] vecRes = new double[]{0.6667, 0.0, 0.0};
        double[][] matRes = new double[][]{{-2.0, 2.0, 0.0}, {0.0, -2.0, 2.0}, {0.0, 0.0, -2.0}};
        DenseContPhaseVar realVar = new DenseContPhaseVar(vecRes, matRes);
        ECCompleteFitTest.assertTrue((String)"Variable not well fitted from moments (Matrix)", (realVar.getMatrix().add(-1.0, this.calcVar.getMatrix()).norm(Matrix.Norm.Maxvalue) < 0.001 ? 1 : 0) != 0);
        ECCompleteFitTest.assertTrue((String)"Variable not well fitted from moments (Vector)", (realVar.getVector().add(-1.0, this.calcVar.getVector()).norm(Vector.Norm.Infinity) < 0.001 ? 1 : 0) != 0);
    }

    public void testParamCaso3() {
        this.m1 = 1.53;
        this.m2 = 10.94;
        this.m3 = 148.57;
        this.fitter = new MomentsECCompleteFit(this.m1, this.m2, this.m3);
        this.calcVar = this.fitter.fit();
        double[] vecRes = new double[]{1.0, 0.0};
        double[][] matRes = new double[][]{{-1.845307614, 0.388202144}, {0.0, -0.212909421}};
        DenseContPhaseVar realVar = new DenseContPhaseVar(vecRes, matRes);
        ECCompleteFitTest.assertTrue((String)"Variable non well fitted from moments (Matrix)", (realVar.getMatrix().add(-1.0, this.calcVar.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        ECCompleteFitTest.assertTrue((String)"Variable non well fitted from moments (Vector)", (realVar.getVector().add(-1.0, this.calcVar.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testParamCaso4() {
        this.m1 = 1.0;
        this.m2 = 2.0;
        this.m3 = 4.571358;
        this.fitter = new MomentsECCompleteFit(this.m1, this.m2, this.m3);
        this.calcVar = this.fitter.fit();
        double[] vecRes = new double[]{0.583321346, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[][] matRes = new double[][]{{-3.500431608, 3.500431608, 0.0, 0.0, 0.0, 0.0}, {0.0, -3.500431608, 3.500431608, 0.0, 0.0, 0.0}, {0.0, 0.0, -3.500431608, 3.500431608, 0.0, 0.0}, {0.0, 0.0, 0.0, -3.500431608, 3.500431608, 0.0}, {0.0, 0.0, 0.0, 0.0, -3.500431608, 3.500431608}, {0.0, 0.0, 0.0, 0.0, 0.0, -3.497412587}};
        DenseContPhaseVar realVar = new DenseContPhaseVar(vecRes, matRes);
        System.out.println("Fitted variable: " + this.calcVar.toString());
        ECCompleteFitTest.assertTrue((String)"Variable non well fitted from moments (Matrix)", (realVar.getMatrix().add(-1.0, this.calcVar.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        ECCompleteFitTest.assertTrue((String)"Variable non well fitted from moments (Vector)", (realVar.getVector().add(-1.0, this.calcVar.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }
}

