/*
 * Decompiled with CFR 0.152.
 */
package jphase.distributions;

import cern.colt.list.DoubleArrayList;
import java.util.ArrayList;
import jphase.distributions.EDistribution;
import jphase.distributions.IDistribution;
import umontreal.iro.lecuyer.probdist.LognormalDist;
import umontreal.iro.lecuyer.randvar.LognormalGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

class Lognormal
extends EDistribution
implements IDistribution {
    public Lognormal(ArrayList<Double> paramatros) {
        double media = 0.0;
        double desv = 1.0;
        if (paramatros != null) {
            media = paramatros.get(0);
            desv = paramatros.get(1);
        }
        this.generadores = new ArrayList();
        this.generadores.add("LogNormalGen");
        this.parametros = new ArrayList();
        this.parametros.add("mu");
        this.parametros.add("sigma");
        this.distribucion = new LognormalDist(media, desv);
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String nombre, ArrayList<Double> paramatros) {
        double media = 30.0;
        double desv = 1.0;
        if (paramatros != null) {
            media = paramatros.get(0);
            desv = paramatros.get(1);
        }
        if (nombre.equals("LogNormalGen")) {
            this.generador = new LognormalGen(s, media, desv);
        }
        return this.generador;
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String d) {
        this.generador = new LognormalGen(s, (LognormalDist)this.darDistribucion());
        return this.generador;
    }

    @Override
    public void ajustarParametros(DoubleArrayList data) {
        double[] para = LognormalDist.getMLE((double[])data.elements(), (int)data.size());
        this.distribucion = new LognormalDist(para[0], para[1]);
    }

    @Override
    public double[] getMoments() {
        double[] mom;
        mom = new double[]{this.distribucion.getMean(), this.distribucion.getStandardDeviation(), (Math.exp(mom[1] * mom[1]) + 2.0) * Math.sqrt(Math.exp(mom[1] * mom[1]) - 1.0)};
        return mom;
    }

    @Override
    public String aString() {
        LognormalDist dis = (LognormalDist)this.distribucion;
        return "Lognormal with mu: " + this.nSig(dis.getMu(), 3) + ", sigma:  " + this.nSig(dis.getSigma(), 3);
    }

    @Override
    public String getName() {
        return "Lognormal";
    }
}

