/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import cern.colt.list.DoubleArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import jphase.FittingLEcuyer;
import jphase.distributions.DistributionManager;
import jphase.distributions.IDistribution;
import jphase.distributions.UniformManager;
import jphase.values.FitResult;
import jphase.values.GenerationResult;
import jphase.values.ReaderWriter;
import umontreal.iro.lecuyer.probdist.Distribution;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class GeneratorLEcuyer {
    public RandomVariateGen generador;
    public RandomStream randomStream;
    public IDistribution distribucion;
    public String uniforme = "RandRijndael(Default)";
    public String ruta;
    public UniformManager manejadorUni = new UniformManager();
    public DistributionManager manejadorDist = new DistributionManager();
    public int n = 1000;
    private String nombre;

    public GeneratorLEcuyer() {
        this.randomStream = this.manejadorUni.darDistribucion(this.uniforme);
        this.distribucion = this.manejadorDist.darDistribucion("Normal", null);
        this.generador = this.distribucion.darGenerador(this.randomStream, null);
    }

    public FitResult generar() throws FileNotFoundException {
        this.generador = this.distribucion.darGenerador();
        DoubleArrayList lista = new DoubleArrayList();
        int i = 0;
        while (i != this.n) {
            double dub = this.generador.nextDouble();
            lista.add(dub);
            ++i;
        }
        PrintWriter out = this.obtenerRuta(this.ruta, String.valueOf(this.nombre) + ".txt");
        ReaderWriter.escritor(out, lista);
        FittingLEcuyer fit = new FittingLEcuyer();
        return fit.fit(10, String.valueOf(this.ruta) + "\\" + this.nombre + ".txt", this.distribucion.toString(), 95.0);
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public RandomVariateGen getGenerador() {
        return this.generador;
    }

    public void setGenerador(RandomVariateGen generador) {
        this.generador = generador;
    }

    public IDistribution getDistribucion() {
        return this.distribucion;
    }

    public void setDistribucion(IDistribution Xdistribucion) {
        this.distribucion = Xdistribucion;
    }

    public String getUniforme() {
        return this.uniforme;
    }

    public void setUniforme(String uniforme) {
        this.uniforme = uniforme;
        this.randomStream = this.manejadorUni.darDistribucion(uniforme);
    }

    public String getRuta() {
        return this.ruta;
    }

    public void setRuta(String ruta) {
        this.ruta = ruta;
    }

    public ArrayList<String> darGeneradoresUniformes() {
        return this.manejadorUni.darDistribuciones();
    }

    public ArrayList<String> darDistribuciones() {
        return this.manejadorDist.darDistribuciones();
    }

    public String darInfoUnif(String evento) {
        return this.manejadorUni.darInfoUnif(evento);
    }

    public IDistribution darDistribucion(String distT, ArrayList<Double> paramatros) {
        return this.manejadorDist.darDistribucion(distT, paramatros);
    }

    public void setDistribucion(String distri, ArrayList<Double> valores) {
        IDistribution iDis = this.manejadorDist.darDistribucion(distri, valores);
        this.setDistribucion(iDis);
    }

    public void setUbicacion(String ubicacion) {
        this.ruta = ubicacion;
    }

    public void setRandomStream(RandomStream rs) {
        this.randomStream = rs;
    }

    public PrintWriter obtenerRuta(String ruta, String nombre) throws FileNotFoundException {
        File directorioFacturas = new File(ruta);
        if (!directorioFacturas.exists()) {
            directorioFacturas.mkdirs();
        }
        File archivoFactura = new File(directorioFacturas, nombre);
        PrintWriter out = new PrintWriter(archivoFactura);
        return out;
    }

    public GenerationResult darInfo() {
        return new GenerationResult((Distribution)this.distribucion.darDistribucion(), this.n, this.ruta);
    }

    public double[] generateMoments() throws FileNotFoundException {
        double[] dob = this.distribucion.getMoments();
        PrintWriter out = this.obtenerRuta(this.ruta, String.valueOf(this.nombre) + ".txt");
        ReaderWriter.escritor(out, new DoubleArrayList(dob));
        return dob;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }
}

