/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jphase.AbstractContPhaseVar;
import jphase.PhaseVar;
import jphase.values.FitResult;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

class PhaseFitResultDialog
extends JDialog
implements ActionListener {
    private static final String ACEPTAR = "Ok";
    private static final String SAVE = "Save";
    private static double max;
    private FitResult resultado;
    private JPanel estadisticos;
    private ChartPanel grafico;
    private JFreeChart chart;
    private DefaultTableXYDataset dataset2;
    private JButton aceptar;
    private JButton salvar;

    public PhaseFitResultDialog(FitResult resul) {
        this.setDefaultCloseOperation(2);
        this.resultado = resul;
        this.setTitle("JPhase - GOF for a Phase Type Variable");
        this.aceptar = new JButton(ACEPTAR);
        this.aceptar.setActionCommand(ACEPTAR);
        this.aceptar.addActionListener(this);
        this.salvar = new JButton("Save histogram");
        this.salvar.setActionCommand(SAVE);
        this.salvar.addActionListener(this);
        this.inicializarEstadisticos();
        this.inicializarHistograma();
        JPanel ajusteN = new JPanel();
        ajusteN.add((Component)this.estadisticos, "West");
        ajusteN.add((Component)this.grafico, "East");
        this.add((Component)ajusteN, "North");
        JPanel aux = new JPanel();
        aux.add((Component)this.aceptar, "East");
        aux.add((Component)this.salvar, "West");
        this.add((Component)aux, "South");
        this.setSize(800, 400);
        this.setLocationRelativeTo(null);
    }

    private void inicializarHistograma() {
        max = this.resultado.getP();
        HistogramDataset dataset = new HistogramDataset();
        double[] vector = PhaseFitResultDialog.darMax(this.resultado.getData());
        dataset.addSeries((Comparable)((Object)"Data"), vector, this.resultado.getGroups());
        this.chart = ChartFactory.createHistogram((String)"Data", (String)"x", (String)"F(x)", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        double min = this.chart.getXYPlot().getDomainAxis().getLowerBound();
        double max = this.chart.getXYPlot().getDomainAxis().getUpperBound();
        PhaseVar var = this.resultado.getVar().var;
        XYSeries dataPDF = new XYSeries((Comparable)((Object)this.resultado.getVar().varName), true, false);
        int numPoints = 200;
        double dx = (max - min) / (double)numPoints;
        double x = min;
        int i = 0;
        while (i < numPoints) {
            dataPDF.add(x, ((AbstractContPhaseVar)var).pdf(x));
            x += dx;
            ++i;
        }
        this.dataset2 = new DefaultTableXYDataset();
        this.dataset2.addSeries(dataPDF);
        renderer.setDrawBarOutline(false);
        JFreeChart chart2 = ChartFactory.createXYLineChart((String)("Phase Var " + this.resultado.getVar().varName + " vs Data"), (String)"x", (String)"F(x)", (XYDataset)this.dataset2, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        XYPlot plot2 = (XYPlot)chart2.getPlot();
        NumberAxis domain2 = new NumberAxis();
        plot2.setDataset(1, (XYDataset)dataset);
        plot2.setRenderer(1, (XYItemRenderer)renderer);
        plot2.setRangeAxis(1, (ValueAxis)domain2);
        plot2.mapDatasetToRangeAxis(1, 1);
        this.grafico = new ChartPanel(chart2);
        this.chart = this.grafico.getChart();
        this.grafico.setPreferredSize(new Dimension(500, 300));
    }

    private void inicializarEstadisticos() {
        this.estadisticos = new JPanel();
        this.estadisticos.setLayout(new GridLayout(6, 1));
        this.estadisticos.add(new JLabel("Square Error: " + Math.rint(this.resultado.getSqrError() * 1000.0) / 1000.0));
        this.estadisticos.add(new JLabel("\t(Reject if P-value < 0.05)"));
        this.estadisticos.add(new JLabel("\tChi2 P-Value: " + Math.rint(this.resultado.getChi2() * 1000.0) / 1000.0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String evento = e.getActionCommand();
        if (evento.equals(ACEPTAR)) {
            this.dispose();
        } else if (evento.equals(SAVE)) {
            this.saveGraph();
        }
    }

    public void saveGraph() {
        try {
            char[] sys = ("" + System.currentTimeMillis()).toCharArray();
            String name = ".\\data\\Histogram-" + this.resultado.getVar().varName + "-" + sys[sys.length - 4] + sys[sys.length - 3] + sys[sys.length - 2] + sys[sys.length - 1] + ".jpg";
            File file = new File(name);
            ChartUtilities.saveChartAsJPEG((File)file, (JFreeChart)this.chart, (int)500, (int)475);
            JOptionPane.showMessageDialog(this, "The histogram was succesfully created:\n\t" + name, "Done", 1);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "There were problems creating the histogram", "Error", 0);
        }
    }

    public static double[] darMax(double[] unift) {
        int i = unift.length;
        while (i > 0) {
            int j = 0;
            while (j < i - 1) {
                double p1 = unift[j];
                double p2 = unift[j + 1];
                if (p1 > p2) {
                    unift[j] = p2;
                    unift[j + 1] = p1;
                }
                ++j;
            }
            --i;
        }
        int pos = (int)((double)unift.length * max / 100.0);
        double[] list = new double[pos];
        int i2 = 0;
        while (i2 != pos) {
            list[i2] = unift[i2];
            ++i2;
        }
        return list;
    }
}

