/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jphase.DenseContPhaseVar;
import jphase.GUI.FitFrame;
import jphase.GUI.MainFrame;
import jphase.GUI.ParamFrame;
import jphase.PhaseVar;
import jphase.fit.EMHyperErlangFit;
import jphase.fit.EMHyperExpoFit;
import jphase.fit.EMPhaseFit;
import jphase.fit.MomentsACPH2Fit;
import jphase.fit.MomentsACPHFit;
import jphase.fit.MomentsECCompleteFit;
import jphase.fit.MomentsECPositiveFit;
import jphase.fit.PhaseFitter;

public class NewVarFrame
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel principalPanel;
    JLabel alertLabel;
    JTextField textInput;
    ButtonGroup sourceType;
    JRadioButton varSource;
    JRadioButton fitSource;
    JComboBox varType;
    JButton paramVarButton;
    JComboBox fitType;
    JButton paramFitButton;
    JButton yesButton;
    JButton noButton;
    public boolean res = false;
    public PhaseFitter fit;
    public PhaseVar var = null;
    public String varName;
    private int width = 400;
    private int height = 250;

    public NewVarFrame() {
        this.setTitle("JPhase - New Variable Creation");
        this.setResizable(false);
        this.setModal(true);
        this.principalPanel = new JPanel();
        this.principalPanel.setLayout(null);
        this.principalPanel.setPreferredSize(new Dimension(this.width, this.height));
        this.principalPanel.setOpaque(true);
        this.alertLabel = new JLabel("Enter the name of the new Variable");
        this.alertLabel.setBounds(new Rectangle(100, 10, 200, 20));
        this.alertLabel.setFont(new Font("@Arial Unicode MS", 1, 12));
        this.alertLabel.setOpaque(true);
        this.principalPanel.add((Component)this.alertLabel, null);
        this.textInput = new JTextField();
        this.textInput.setBounds(new Rectangle(110, 40, 150, 20));
        this.textInput.setBackground(Color.WHITE);
        this.textInput.setText("");
        this.principalPanel.add((Component)this.textInput, "Center");
        this.sourceType = new ButtonGroup();
        this.varSource = new JRadioButton("Theoretical Variable");
        this.varSource.setOpaque(true);
        this.varSource.setBounds(new Rectangle(50, 80, 120, 20));
        this.varSource.setSelected(true);
        this.varSource.setActionCommand("SourceVar");
        this.varSource.addActionListener(this);
        this.fitSource = new JRadioButton("Fitted Variable");
        this.fitSource.setOpaque(true);
        this.fitSource.setBounds(new Rectangle(220, 80, 120, 20));
        this.fitSource.setActionCommand("SourceFit");
        this.fitSource.addActionListener(this);
        this.sourceType.add(this.varSource);
        this.sourceType.add(this.fitSource);
        this.principalPanel.add((Component)this.varSource, null);
        this.principalPanel.add((Component)this.fitSource, null);
        String[] vars = new String[]{"Expo", "Erlang", "HyperExponential", "Coxian", "HyperErlang", "General Phase"};
        this.varType = new JComboBox<String>(vars);
        this.varType.setBounds(new Rectangle(70, 110, 120, 20));
        this.principalPanel.add((Component)this.varType, null);
        String[] fits = new String[]{"Moments ACPH2", "Moments EC Complete", "Moments EC Positive", "Moments ACPH", "EMHyperExpoFit", "EMHyperErlangFit", "EMPhaseFit"};
        this.fitType = new JComboBox<String>(fits);
        this.fitType.setBounds(new Rectangle(240, 110, 120, 20));
        this.fitType.setEnabled(false);
        this.principalPanel.add((Component)this.fitType, null);
        this.paramVarButton = new JButton("Parameters");
        this.paramVarButton.setBounds(new Rectangle(80, 160, 90, 25));
        this.paramVarButton.addActionListener(this);
        this.paramVarButton.setActionCommand("Var");
        this.paramVarButton.setOpaque(true);
        this.principalPanel.add((Component)this.paramVarButton, null);
        this.paramFitButton = new JButton("Parameters");
        this.paramFitButton.setBounds(new Rectangle(250, 160, 90, 25));
        this.paramFitButton.addActionListener(this);
        this.paramFitButton.setActionCommand("Fit");
        this.paramFitButton.setOpaque(true);
        this.paramFitButton.setEnabled(false);
        this.principalPanel.add((Component)this.paramFitButton, null);
        this.yesButton = new JButton("Enter");
        this.yesButton.setBounds(new Rectangle(100, 220, 90, 25));
        this.yesButton.setActionCommand("Enter");
        this.yesButton.addActionListener(this);
        this.yesButton.setOpaque(true);
        this.principalPanel.add((Component)this.yesButton, null);
        this.noButton = new JButton("Cancel");
        this.noButton.setBounds(new Rectangle(210, 220, 90, 25));
        this.noButton.setActionCommand("Cancel");
        this.noButton.addActionListener(this);
        this.principalPanel.add((Component)this.noButton, null);
        this.getContentPane().add((Component)this.principalPanel, "Center");
        this.centrarFrame();
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public boolean getRes() {
        return this.res;
    }

    public String getValue() {
        return this.textInput.getText();
    }

    void yesButton_actionPerformed() {
        if (this.textInput.getText().equals("") || !this.res) {
            JOptionPane.showMessageDialog(null, "You need to specify a name and all the parameters", "JPhase Alert", 1);
        } else {
            this.varName = this.textInput.getText();
            this.res = false;
            this.setVisible(false);
        }
    }

    void noButton_actionPerformed() {
        this.res = false;
        this.setVisible(false);
    }

    void paramVarButton_actionPerformed() {
        String reqVar = (String)this.varType.getSelectedItem();
        ParamFrame param = new ParamFrame(reqVar);
        param.setVisible(true);
        if (param.res) {
            int n;
            double[] p = new double[param.paramValues.length];
            int i = 0;
            while (i < p.length) {
                p[i] = Double.valueOf(param.paramValues[i].getText());
                ++i;
            }
            if (reqVar.equals("Expo")) {
                this.var = DenseContPhaseVar.expo(p[0]);
            } else if (reqVar.equals("Erlang")) {
                this.var = DenseContPhaseVar.Erlang(p[0], (int)p[1]);
            } else if (reqVar.equals("Coxian")) {
                n = (int)p[0];
                double[] rates = new double[n];
                double[] probs = new double[n - 1];
                System.arraycopy(p, 1, rates, 0, n);
                System.arraycopy(p, n + 1, probs, 0, n - 1);
                this.var = DenseContPhaseVar.Coxian(n, rates, probs);
            } else if (reqVar.equals("HyperExponential")) {
                n = (int)p[0];
                double[] rates = new double[n];
                double[] probs = new double[n];
                System.arraycopy(p, 1, rates, 0, n);
                System.arraycopy(p, n + 1, probs, 0, n);
                this.var = DenseContPhaseVar.HyperExpo(rates, probs);
            } else if (reqVar.equals("HyperErlang")) {
                n = (int)p[0];
                double[] rates = new double[n];
                double[] probs = new double[n];
                double[] phases = new double[n];
                int[] phasesR = new int[n];
                System.arraycopy(p, 1, rates, 0, n);
                System.arraycopy(p, n + 1, probs, 0, n);
                System.arraycopy(p, 2 * n + 1, phases, 0, n);
                int i2 = 0;
                while (i2 != phases.length) {
                    phasesR[i2] = (int)phases[i2];
                    ++i2;
                }
                this.var = DenseContPhaseVar.HyperErlang(n, rates, phasesR, probs);
            } else {
                System.out.println("NOT YET IMPLEMENTED");
            }
            if (this.var != null) {
                this.res = true;
            }
            System.out.println("trulian " + this.res);
        }
    }

    void paramFitButton_actionPerformed() {
        this.res = false;
        String reqFit = (String)this.fitType.getSelectedItem();
        FitFrame param = new FitFrame(reqFit);
        if (param.getRes()) {
            double[] p = new double[param.paramValues.length];
            int i = 0;
            while (i < p.length) {
                p[i] = Double.valueOf(param.paramValues[i].getText());
                ++i;
            }
            double[] data = param.getData();
            if (reqFit.equals("Moments ACPH2")) {
                this.fit = new MomentsACPH2Fit(data);
                this.var = this.fit.fit();
            } else if (reqFit.equals("Moments EC Complete")) {
                this.fit = new MomentsECCompleteFit(data);
                this.var = this.fit.fit();
            } else if (reqFit.equals("Moments EC Positive")) {
                this.fit = new MomentsECPositiveFit(data);
                this.var = this.fit.fit();
            } else if (reqFit.equals("Moments ACPH")) {
                this.fit = new MomentsACPHFit(data);
                this.var = this.fit.fit();
            } else if (reqFit.equals("EMHyperExpoFit")) {
                this.fit = new EMHyperExpoFit(data);
                this.var = this.fit.fit();
            } else if (reqFit.equals("EMHyperErlangFit")) {
                this.fit = new EMHyperErlangFit(data);
                this.var = this.fit.fit();
            } else if (reqFit.equals("EMPhaseFit")) {
                this.fit = new EMPhaseFit(data);
                this.var = this.fit.fit();
            } else {
                System.out.println("NOT YET IMPLEMENTED");
            }
            this.varName = this.getValue();
            if (this.var != null) {
                this.res = true;
            } else {
                JOptionPane.showMessageDialog(null, "Variable could not be fitted with the requested method\n More information in log", "JPhase Alert", 1);
                MainFrame.getInstance().addLog("Variable could not be fitted with the requested method");
                this.setVisible(false);
            }
        }
    }

    void varSource_actionPerformed() {
        this.varType.setEnabled(true);
        this.varType.setForeground(Color.DARK_GRAY);
        this.paramVarButton.setEnabled(true);
        this.fitType.setEnabled(false);
        this.fitType.setForeground(Color.LIGHT_GRAY);
        this.paramFitButton.setEnabled(false);
    }

    void fitSource_actionPerformed() {
        this.varType.setEnabled(false);
        this.varType.setForeground(Color.LIGHT_GRAY);
        this.paramVarButton.setEnabled(false);
        this.fitType.setEnabled(true);
        this.fitType.setForeground(Color.DARK_GRAY);
        this.paramFitButton.setEnabled(true);
    }

    private void centrarFrame() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - this.width) / 2, (screenSize.height - this.height) / 2);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String evento = arg0.getActionCommand();
        if (evento.equals("Fit")) {
            this.paramFitButton_actionPerformed();
        } else if (evento.equals("Var")) {
            this.paramVarButton_actionPerformed();
        } else if (evento.equals("SourceVar")) {
            this.varSource_actionPerformed();
        } else if (evento.equals("SourceFit")) {
            this.fitSource_actionPerformed();
        } else if (evento.equals("Enter")) {
            this.yesButton_actionPerformed();
        } else if (evento.equals("Cancel")) {
            this.noButton_actionPerformed();
        }
    }
}

