/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import jphase.GUI.GenerateVarFrame;
import jphase.GUI.InputFrame;
import jphase.GUI.NewQueueDialog;
import jphase.GUI.NewVarFrame;
import jphase.GUI.PhaseGOF;
import jphase.GUI.PhaseVarInfo;
import jphase.GUI.TreeManagerPanel;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static MainFrame instance;
    private JTextArea log;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem newItem;
    private JMenuItem openItem;
    private JMenuItem saveItem;
    private JMenuItem closeItem;
    private JMenuItem exitItem;
    private JMenu phVarMenu;
    private JMenuItem newSetItem;
    private JMenuItem newVarItem;
    private JMenuItem newVarGItem;
    private JMenuItem newQueue;
    private JMenu helpMenu;
    private JMenuItem aboutItem;
    private JToolBar toolBar;
    private JPanel mainPane;
    private TreeManagerPanel treeContentPane;
    private int width = 700;
    private int height = 400;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new MainFrame();
    }

    public static MainFrame getInstance() {
        if (instance == null) {
            instance = new MainFrame();
        }
        return instance;
    }

    public MainFrame() {
        this.setTitle("JPhase - Java Framework for Phase Type Distributions");
        this.setIconImage(new ImageIcon("images/var.jpg").getImage());
        this.setDefaultCloseOperation(3);
        this.setFocusable(true);
        this.setResizable(true);
        this.menuBar = new JMenuBar();
        this.menuBar.setVisible(true);
        this.menuBar.setPreferredSize(new Dimension(this.width, 25));
        this.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.menuBar.add(this.fileMenu);
        this.newItem = new JMenuItem("New");
        this.newItem.addActionListener(new MainFrame_newItem_actionAdapter(this));
        this.fileMenu.add(this.newItem);
        this.openItem = new JMenuItem("Open");
        this.fileMenu.add(this.openItem);
        this.saveItem = new JMenuItem("Save");
        this.fileMenu.add(this.saveItem);
        this.closeItem = new JMenuItem("Close");
        this.closeItem.addActionListener(new MainFrame_closeItem_actionAdapter(this));
        this.fileMenu.add(this.closeItem);
        this.exitItem = new JMenuItem("Exit");
        this.exitItem.addActionListener(new MainFrame_exitItem_actionAdapter(this));
        this.fileMenu.add(this.exitItem);
        this.phVarMenu = new JMenu("Phase Var");
        this.phVarMenu.setMnemonic(80);
        this.menuBar.add(this.phVarMenu);
        this.newSetItem = new JMenuItem("New Set");
        this.newSetItem.addActionListener(new MainFrame_newSetItem_actionAdapter(this));
        this.phVarMenu.add(this.newSetItem);
        this.newVarItem = new JMenuItem("New Phase-type Variable");
        this.newVarItem.addActionListener(new MainFrame_newVarItem_actionAdapter(this));
        this.phVarMenu.add(this.newVarItem);
        this.newVarGItem = new JMenuItem("New General Variable");
        this.newVarGItem.addActionListener(new MainFrame_newVarGItem_actionAdapter(this));
        this.phVarMenu.add(this.newVarGItem);
        this.newQueue = new JMenuItem("Generate a PH/PH/1 Queue");
        this.newQueue.addActionListener(new MainFrame_newQueue_actionAdapter(this));
        this.phVarMenu.add(this.newQueue);
        this.newQueue = new JMenuItem("GOF for a Phase-Type Variable");
        this.newQueue.addActionListener(new MainFrame_GROPhase_actionAdapter(this));
        this.phVarMenu.add(this.newQueue);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        this.menuBar.add(this.helpMenu);
        this.aboutItem = new JMenuItem("About JPhase");
        this.aboutItem.addActionListener(new MainFrame_aboutItem_actionAdapter(this));
        this.helpMenu.add(this.aboutItem);
        this.toolBar = new JToolBar("ToolBar");
        JButton newButton = new JButton(new ImageIcon("images/new.jpg"));
        newButton.setToolTipText("Cargar archivo caudal entrante");
        newButton.addActionListener(new MainFrame_newItem_actionAdapter(this));
        this.toolBar.add(newButton);
        JButton openButton = new JButton(new ImageIcon("images/open.jpg"));
        openButton.setToolTipText("Create a new distribution");
        this.toolBar.add(openButton);
        JButton saveButton = new JButton(new ImageIcon("images/save.jpg"));
        saveButton.setToolTipText("Save distribution");
        this.toolBar.add(saveButton);
        this.add((Component)this.toolBar, "First");
        this.mainPane = new JPanel();
        this.mainPane.setLayout(null);
        this.mainPane.setPreferredSize(new Dimension(this.width, this.height));
        this.mainPane.setBackground(Color.LIGHT_GRAY);
        this.getContentPane().add((Component)this.mainPane, "Center");
        this.log = new JTextArea(2, 8);
        this.log.setFont(new Font("@Arial Unicode MS", 0, 11));
        this.log.setEditable(false);
        JScrollPane logScrollPane = new JScrollPane(this.log);
        this.getContentPane().add((Component)logScrollPane, "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
    }

    public void addLog(String str) {
        if (str != null) {
            this.log.append(str);
        }
    }

    void newItem_actionPerformed(ActionEvent e) {
        if (this.treeContentPane != null) {
            this.getContentPane().remove(this.treeContentPane);
            this.treeContentPane.tree.removeAll();
            this.treeContentPane.treeModel.setRoot(null);
            this.treeContentPane.removeAll();
            this.treeContentPane = null;
        }
        this.treeContentPane = new TreeManagerPanel();
        this.treeContentPane.setOpaque(true);
        this.treeContentPane.setPreferredSize(new Dimension(this.width, this.height));
        if (this.mainPane != null) {
            this.remove(this.mainPane);
            this.mainPane = null;
        }
        this.getContentPane().add((Component)this.treeContentPane, "Center");
        this.pack();
    }

    void closeItem_actionPerformed(ActionEvent e) {
        int res = JOptionPane.showConfirmDialog(null, "Are you sure you want to close the present JPhase calculator?", "JPhase: Close?", 0);
        if (res == 0) {
            if (this.treeContentPane != null) {
                this.getContentPane().remove(this.treeContentPane);
                this.treeContentPane.tree.removeAll();
                this.treeContentPane.treeModel.setRoot(null);
                this.treeContentPane.removeAll();
                this.treeContentPane = null;
            }
            this.mainPane = new JPanel();
            this.mainPane.setLayout(null);
            this.mainPane.setPreferredSize(new Dimension(this.width, this.height));
            this.mainPane.setBackground(Color.LIGHT_GRAY);
            this.getContentPane().add((Component)this.mainPane, "Center");
            this.getContentPane().add(this.mainPane);
            this.getContentPane().setBackground(Color.LIGHT_GRAY);
            this.pack();
        }
    }

    void exitItem_actionPerformed(ActionEvent e) {
        int res = JOptionPane.showConfirmDialog(null, "Are you sure you want to exit JPhase?", "JPhase: Exit?", 0);
        if (res == 0) {
            System.exit(0);
        }
    }

    void newSetItem_actionPerformed(ActionEvent e) {
        if (this.treeContentPane == null) {
            JOptionPane.showMessageDialog(null, "There must be an active file to create a Set", "JPhase Alert", 1);
        } else {
            InputFrame newSetFrame = new InputFrame("JPhase: New Set Creation", "Enter the name of the new Set");
            newSetFrame.setVisible(true);
            newSetFrame.setFocusable(true);
            if (newSetFrame.getRes()) {
                this.treeContentPane.addSet(newSetFrame.getValue());
                this.pack();
            }
        }
    }

    void newVarItem_actionPerformed(ActionEvent e) {
        if (this.treeContentPane == null) {
            JOptionPane.showMessageDialog(null, "There must be an active file to create a Variable", "JPhase Alert", 1);
        } else {
            boolean res = this.treeContentPane.canAddVar();
            if (!res) {
                this.log.append("New variable cannot be created without specifying a Set.\n");
            } else {
                NewVarFrame myFrame = new NewVarFrame();
                myFrame.setVisible(true);
                this.treeContentPane.addVar(myFrame.varName, myFrame.var);
                this.pack();
            }
        }
    }

    void newVarGItem_actionPerformed(ActionEvent e) {
        GenerateVarFrame interfazVariables = new GenerateVarFrame();
        interfazVariables.setVisible(true);
    }

    void newQueue_actionPerformed(ActionEvent e) {
        NewQueueDialog dialog = new NewQueueDialog(this);
        dialog.setVisible(true);
    }

    void GOFPhase_actionPerformed(ActionEvent e) {
        PhaseGOF dialog = new PhaseGOF(this);
        dialog.setVisible(true);
    }

    void aboutItem_actionPerformed(ActionEvent e) {
        String s = "JPhase was developed by \n   Juan F. P\u00e9rez \n  Germ\u00e1n Ria\u00f1o Mendoza \n\n  Andr\u00e9s Sarmiento \n\nUniversidad de los Andes\nBogot\u00e1, Colombia\nVersion 1.0 (2006-2014)";
        JOptionPane.showMessageDialog(null, s, "JPhase About", 1);
    }

    private String getSuffix(File f) {
        String s = f.getPath();
        String suffix = null;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            suffix = s.substring(i + 1).toLowerCase();
        }
        return suffix;
    }

    public ArrayList<PhaseVarInfo> getVariables() {
        if (this.treeContentPane == null) {
            JOptionPane.showMessageDialog(null, "There must be an active file to create a Variable", "JPhase Alert", 1);
        } else {
            boolean res = this.treeContentPane.canAddVar();
            if (!res) {
                this.log.append("You must specify a Set before.\n");
            } else {
                return this.treeContentPane.getVariables();
            }
        }
        return null;
    }

    class MainFrame_GROPhase_actionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_GROPhase_actionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.GOFPhase_actionPerformed(e);
        }
    }

    class MainFrame_aboutItem_actionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_aboutItem_actionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.aboutItem_actionPerformed(e);
        }
    }

    class MainFrame_closeItem_actionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_closeItem_actionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.closeItem_actionPerformed(e);
        }
    }

    class MainFrame_exitItem_actionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_exitItem_actionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.exitItem_actionPerformed(e);
        }
    }

    class MainFrame_newItem_actionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_newItem_actionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.newItem_actionPerformed(e);
        }
    }

    class MainFrame_newQueue_actionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_newQueue_actionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.newQueue_actionPerformed(e);
        }
    }

    class MainFrame_newSetItem_actionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_newSetItem_actionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.newSetItem_actionPerformed(e);
        }
    }

    class MainFrame_newVarGItem_actionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_newVarGItem_actionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.newVarGItem_actionPerformed(e);
        }
    }

    class MainFrame_newVarItem_actionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_newVarItem_actionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.newVarItem_actionPerformed(e);
        }
    }

    class TextFilter
    extends FileFilter {
        TextFilter() {
        }

        @Override
        public boolean accept(File f) {
            String suffix;
            boolean accept = f.isDirectory();
            if (!accept && (suffix = MainFrame.this.getSuffix(f)) != null) {
                accept = suffix.equals("txt");
            }
            return accept;
        }

        @Override
        public String getDescription() {
            return "Text files(*.txt)";
        }
    }
}

