/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jphase.GUI.GeneratorPanel;
import jphase.GeneratorLEcuyer;
import jphase.distributions.IDistribution;

class GeneratorDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public final String ACEPTAR = "Acept";
    public final String CANCELAR = "Cancel";
    public GeneratorPanel panel;
    public GeneratorLEcuyer gen;
    public ButtonGroup grupo;
    public JButton aceptarB;
    public JButton cancelarB;
    public ArrayList<JRadioButton> botones;
    public ArrayList<String> generadores;

    public GeneratorDialog(GeneratorLEcuyer genle, GeneratorPanel pan) {
        this.panel = pan;
        this.gen = genle;
        this.aceptarB = new JButton("Acept");
        this.aceptarB.setActionCommand("Acept");
        this.aceptarB.addActionListener(this);
        this.cancelarB = new JButton("Cancel");
        this.cancelarB.setActionCommand("Cancel");
        this.cancelarB.addActionListener(this);
        IDistribution dist = this.gen.getDistribucion();
        this.generadores = dist.darGeneradores();
        this.botones = new ArrayList();
        this.grupo = new ButtonGroup();
        this.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(this.generadores.size() + 1, 1));
        this.setSize(200, this.generadores.size() * 30 + 50);
        this.setResizable(false);
        int i = 0;
        while (i != this.generadores.size()) {
            String nom = this.generadores.get(i);
            JRadioButton boton = new JRadioButton(nom);
            this.grupo.add(boton);
            this.botones.add(boton);
            p1.add(boton);
            if (i == 0) {
                boton.setSelected(true);
            }
            ++i;
        }
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.cancelarB, "West");
        p.add((Component)this.aceptarB, "East");
        this.add((Component)p, "South");
        this.add((Component)p1, "North");
        this.setLocationRelativeTo(null);
        this.setTitle("Generators");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String evento = e.getActionCommand();
        if (evento.equals("Acept")) {
            int j = 0;
            int i = 0;
            while (i != this.botones.size()) {
                if (this.botones.get(i).isSelected()) {
                    j = i;
                    break;
                }
                ++i;
            }
            this.panel.setGen(this.generadores.get(j));
            this.dispose();
        } else if (evento.equals("Cancel")) {
            this.dispose();
        } else {
            this.darInfo(evento);
        }
    }

    public void darInfo(String evento) {
        String info = this.panel.darInfoUnif(evento);
        JOptionPane.showMessageDialog(this, info, String.valueOf(evento) + info, 1);
    }

    @Override
    public void dispose() {
        this.panel.reEnable();
        super.dispose();
    }
}

