/*
 * Decompiled with CFR 0.152.
 */
package jmdp;

import examples.jmdp.InvLevel;
import examples.jmdp.Order;
import examples.jmdp.WagnerWhitin;
import jmarkov.jmdp.solvers.FiniteSolver;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class WagnerWhitinTest
extends TestCase {
    WagnerWhitin prob = null;

    public static void main(String[] args) {
        TestRunner.run(WagnerWhitinTest.class);
    }

    public WagnerWhitinTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        int lastStage = 12;
        int maxInventory = 15;
        int maxBackorders = 5;
        int truckSize = 6;
        double K = 500.0;
        double b = 2000.0;
        double p = 22000.0;
        double c = 20000.0;
        double h = Math.pow(1.3, 0.019230769230769232) - 1.0;
        int[] nArray = new int[12];
        nArray[0] = 10;
        nArray[1] = 4;
        nArray[2] = 3;
        nArray[3] = 6;
        nArray[4] = 3;
        nArray[5] = 2;
        nArray[7] = 1;
        nArray[8] = 7;
        nArray[9] = 3;
        nArray[10] = 4;
        nArray[11] = 5;
        int[] demand = nArray;
        this.prob = new WagnerWhitin(0, lastStage, maxInventory, maxBackorders, truckSize, K, b, p, c, h, demand);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.prob = null;
    }

    public void testSolve() {
        FiniteSolver<InvLevel, Order> theSolver = new FiniteSolver<InvLevel, Order>(this.prob);
        theSolver.solve();
    }

    public void testgetOptimalValueFunction() throws Exception {
        InvLevel initial = new InvLevel(0);
        double vf = this.prob.getOptimalValueFunction().get(initial);
        double vf_cero = 1005.8216;
        WagnerWhitinTest.assertEquals((String)"Value Function not equal", (double)vf_cero, (double)vf, (double)0.001);
    }
}

