/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jqbd.solvers;

import jmarkov.jqbd.solvers.QBDPhaseSolver;
import jphase.PhaseVar;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;

public class CLPAlgorithm
extends QBDPhaseSolver {
    public CLPAlgorithm(PhaseVar arrivals, PhaseVar service) {
        this.initilicePHPH1(arrivals, service);
    }

    @Override
    public double[][] getRmatrix() {
        int dimen = this.MA1.numRows();
        DenseMatrix I = new DenseMatrix((Matrix)Matrices.identity((int)dimen));
        DenseMatrix mA1I = new DenseMatrix(dimen, dimen);
        this.G = new DenseMatrix(dimen, dimen);
        this.U = new DenseMatrix(dimen, dimen);
        this.N = new DenseMatrix(dimen, dimen);
        DenseMatrix UA = new DenseMatrix(dimen, dimen);
        this.R = new DenseMatrix(dimen, dimen);
        this.U.set(this.MA1);
        this.U.mult(-1.0, (Matrix)I, (Matrix)UA);
        UA.solve((Matrix)I, (Matrix)mA1I);
        mA1I.mult(this.MA2, (Matrix)this.G);
        double compare = 1.0;
        double epsilon = 0.1;
        while (compare > epsilon) {
            this.U.set(this.MA1);
            this.MA0.multAdd((Matrix)this.G, (Matrix)this.U);
            mA1I = new DenseMatrix(dimen, dimen);
            this.U.mult(-1.0, (Matrix)I, (Matrix)UA);
            UA.solve((Matrix)I, (Matrix)mA1I);
            this.N.set((Matrix)mA1I);
            mA1I.mult(this.MA2, (Matrix)this.G);
            double[][] ones = new double[this.G.numRows()][1];
            int i = 0;
            while (i < this.G.numRows()) {
                ones[i][0] = 1.0;
                ++i;
            }
            DenseMatrix one = new DenseMatrix(ones);
            DenseMatrix check = new DenseMatrix(this.G.numRows(), 1);
            this.G.mult(-1.0, (Matrix)one, (Matrix)check);
            check.add((Matrix)one);
            compare = Math.abs(check.get(0, 0));
            int i2 = 1;
            while (i2 < check.numRows()) {
                compare = Math.max(compare, Math.abs(check.get(i2, 0)));
                ++i2;
            }
        }
        this.U.set(this.MA1);
        this.MA0.multAdd((Matrix)this.G, (Matrix)this.U);
        mA1I = new DenseMatrix(dimen, dimen);
        this.U.mult(-1.0, (Matrix)I, (Matrix)UA);
        UA.solve((Matrix)I, (Matrix)mA1I);
        this.N.set((Matrix)mA1I);
        this.MA0.mult((Matrix)mA1I, (Matrix)this.R);
        return Matrices.getArray((Matrix)this.R);
    }

    public String label() {
        return "Continuous Linear Progresion algorithm solver.";
    }
}

