/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import java.io.PrintWriter;
import jmarkov.basic.Action;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.jmdp.CTMDP;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.solvers.AbstractAverageSolver;
import jmarkov.jmdp.solvers.ValueIterationSolver;

public class RelativeValueIterationSolver<S extends State, A extends Action>
extends AbstractAverageSolver<S, A> {
    private ValueIterationSolver<S, A> valueSolver;

    public RelativeValueIterationSolver(DTMDP<S, A> problem) {
        super(problem);
        this.valueSolver = new ValueIterationSolver<S, A>(problem, false);
    }

    public RelativeValueIterationSolver(DTMDP<S, A> problem, double factor) {
        super(problem);
        this.valueSolver = new ValueIterationSolver<S, A>(problem, true);
        this.setFactor(factor);
    }

    public RelativeValueIterationSolver(CTMDP<S, A> problem) {
        super(problem);
        this.valueSolver = new ValueIterationSolver<S, A>(problem, false);
    }

    public RelativeValueIterationSolver(CTMDP<S, A> problem, double factor) {
        super(problem);
        this.valueSolver = new ValueIterationSolver<S, A>(problem, true);
        this.setFactor(factor);
    }

    @Override
    public void setPrintValueFunction(boolean val) {
        this.printValueFunction = val;
        this.valueSolver.setPrintValueFunction(val);
    }

    public void setFactor(double factor) {
        if (!(factor < 1.0) || !(factor > 0.0)) {
            if (!this.valueSolver.usesModifiedAverage()) {
                throw new IllegalArgumentException("Trying to set convergence factor when Mofified Average is not enabled!");
            }
            throw new IllegalArgumentException("Factor set outside the valid range (0,1).");
        }
        this.valueSolver.discountFactor = factor;
    }

    @Override
    public String label() {
        return "Relative Value Iteration Solver";
    }

    @Override
    public Solution<S, A> solve() {
        Solution<S, A> sol = this.valueSolver.solve();
        this.solved = true;
        this.valueFunction = sol.getValueFunction();
        this.policy = sol.getPolicy();
        return sol;
    }

    @Override
    public final long getProcessTime() {
        return this.valueSolver.getProcessTime();
    }

    @Override
    public final long getIterations() {
        return this.valueSolver.getIterations();
    }

    public void setPrintBias(boolean val) {
        this.valueSolver.setPrintBias(val);
    }

    public void setPrintGain(boolean val) {
        this.valueSolver.setPrintGain(val);
    }

    public double getGain() {
        return this.valueSolver.getGain();
    }

    @Override
    public void printSolution(PrintWriter pw) {
        this.valueSolver.printSolution(pw);
    }

    @Override
    public void printSolution() throws Exception {
        this.printSolution(new PrintWriter(System.out));
    }
}

