/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.StringTokenizer;
import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.DecisionRule;
import jmarkov.basic.Policy;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.InfiniteMDP;
import jmarkov.jmdp.solvers.MpsLpDiscountedSolver;

public class MPSXpressDiscounted<S extends State, A extends Action>
extends MpsLpDiscountedSolver<S, A> {
    private static final String INVCOMMAS = "\"\"";
    private static final String COMMA = ",";
    private static String fs = System.getProperty("file.separator");
    private String fileName = "";
    private Scanner input;
    private String outFileName = "";
    private boolean showXpressOutput = false;

    public MPSXpressDiscounted(DTMDP<S, A> problem, double interestRate, String workingDir, String fileName) {
        super(problem, interestRate, workingDir, fileName);
    }

    public MPSXpressDiscounted(DTMDP<S, A> problem, double interestRate) {
        super(problem, interestRate);
    }

    @Override
    public long getIterations() {
        return 0L;
    }

    @Override
    public void solveLP() throws SolverException {
        File mpsFile = this.getMpsFile();
        File commandFile = new File(this.getWorkingDir(), "commands.bat");
        String runCommand = "";
        String mpsFileShortName = "";
        try {
            if (!mpsFile.exists()) {
                throw new IOException("MPS File " + mpsFile.getAbsolutePath() + " does not exist.");
            }
            commandFile = this.createCommandsFile();
            mpsFileShortName = this.cutExt(mpsFile.toString());
            String comFileName = commandFile.getPath();
            runCommand = "optimizer " + mpsFileShortName + " @" + comFileName;
            Runtime runTime = Runtime.getRuntime();
            Process process = runTime.exec(runCommand);
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (!this.showXpressOutput) continue;
                System.out.println(line);
            }
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 64) {
                switch (exitValue) {
                    case 65: {
                        throw new SolverException("Xpress found the problem to be infeasible.");
                    }
                    case 66: {
                        throw new SolverException("Xpress found the problem to be unbounded.");
                    }
                    case 128: {
                        throw new SolverException("Xpress licensing error 4: The maximum number of simultaneous users has been reached. Check that no other copies of Xpress-MP are running, or contact license@dashoptimization.com if you would like to upgrade to a multi-user license.");
                    }
                }
                throw new SolverException("ERROR: Xpress exit value =" + exitValue);
            }
        }
        catch (IOException e) {
            throw new SolverException("Error invoking XPresss. This solver requires Xpress professional. The run command was " + runCommand + ". Exception produced: " + e);
        }
        catch (InterruptedException e) {
            throw new SolverException("XPresss Execution was suspended! : . The run command was " + runCommand + ". Exception produced: " + e);
        }
        this.outFileName = String.valueOf(mpsFileShortName) + ".asc";
    }

    public File createCommandsFile() throws IOException {
        File commandFile = new File("Commands.bat");
        Writer bw = new OutputStreamWriter(new FileOutputStream(commandFile));
        bw = new BufferedWriter(bw);
        String mpsFileName = this.getMpsFile().getCanonicalPath();
        bw.write("readprob " + mpsFileName + "\nminim\nwritesol\nstop\nquit");
        bw.flush();
        return commandFile;
    }

    String cutExt(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos == -1) {
            pos = fileName.length();
        }
        return fileName.substring(0, pos);
    }

    void cdWorking() {
        File workingFolder = this.getWorkingDir();
        if (workingFolder.isDirectory()) {
            System.setProperty("user.dir", workingFolder.getAbsolutePath());
            String newDir = System.getProperty("user.dir");
            this.problem.debug(1, "Dir set to: " + newDir);
        }
    }

    @Override
    public String label() {
        return "MPS Xpress Solver (Disc)";
    }

    public boolean showXpressOutput() {
        return this.showXpressOutput;
    }

    public void setShowXpressOutput(boolean showXpressOutput) {
        this.showXpressOutput = showXpressOutput;
    }

    public void openFile() throws SolverException {
        try {
            this.input = new Scanner(new File(this.outFileName));
        }
        catch (IOException fileNotFoundException) {
            throw new SolverException("Error opening file: " + this.outFileName);
        }
    }

    public void closeFile() {
        if (this.input != null) {
            this.input.close();
        }
    }

    @Override
    public Solution<S, A> buildSolution() throws SolverException {
        DecisionRule<State, Action> decisionRule = new DecisionRule<State, Action>();
        this.policy = new Policy(decisionRule);
        double gain = 0.0;
        int counter = 0;
        int numActions = 0;
        boolean obj = false;
        StatesSet states = this.getDiscreteProblem().getAllStates();
        Iterator stateIteratorVF = states.iterator();
        Iterator stateIteratorDR = states.iterator();
        State stateDR = null;
        boolean newState = true;
        Actions actions = null;
        Iterator actionsIterator = null;
        Action action = null;
        this.openFile();
        try {
            block3: while (this.input.hasNextLine()) {
                String lineAux = this.input.nextLine();
                StringTokenizer value = new StringTokenizer(lineAux, COMMA);
                if (this.discountFactor == 1.0 && !obj) {
                    int pos = 0;
                    while (pos < 4) {
                        value.nextToken();
                        ++pos;
                    }
                    gain = new Double(value.nextToken());
                    obj = true;
                    continue;
                }
                if (!obj) {
                    obj = true;
                    continue;
                }
                if (value.countTokens() == 10) {
                    State state = (State)stateIteratorVF.next();
                    counter = 0;
                    Double answer = null;
                    while (value.hasMoreTokens()) {
                        value.nextToken();
                        if (++counter != 8) continue;
                        String constraintValue = value.nextToken();
                        answer = new Double(constraintValue);
                        if (this.discountFactor == 1.0) {
                            this.valueFunction.set(state, gain);
                            break;
                        }
                        this.valueFunction.set(state, answer);
                        break;
                    }
                }
                if (value.countTokens() != 9) continue;
                Double answer = null;
                boolean notTransient = true;
                if (newState) {
                    stateDR = (State)stateIteratorDR.next();
                    actions = ((InfiniteMDP)this.getProblem()).feasibleActions(stateDR);
                    actionsIterator = actions.iterator();
                    numActions = actions.size();
                    newState = false;
                }
                counter = 0;
                while (value.hasMoreTokens()) {
                    value.nextToken();
                    if (++counter != 4) continue;
                    String variableValue = value.nextToken();
                    answer = new Double(variableValue);
                    action = (Action)actionsIterator.next();
                    if (answer > 0.0) {
                        decisionRule.set(stateDR, action);
                        notTransient = true;
                    }
                    if (--numActions != 0) continue block3;
                    if (!notTransient) {
                        actionsIterator = actions.iterator();
                        decisionRule.set(stateDR, (Action)actionsIterator.next());
                    }
                    newState = true;
                    continue block3;
                }
            }
        }
        catch (NoSuchElementException elementException) {
            this.input.close();
            throw new SolverException("File improperly formated.", elementException.getCause());
        }
        catch (IllegalStateException stateException) {
            throw new SolverException("Error reading solution from file: " + this.fileName, stateException.getCause());
        }
        this.closeFile();
        this.policy.setDecisionRule(decisionRule);
        return new Solution(this.valueFunction, this.policy);
    }
}

