/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp;

import java.util.Iterator;
import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.DecisionRule;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.ValueFunction;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.CT2DTConverter;
import jmarkov.jmdp.InfiniteMDP;
import jmarkov.jmdp.solvers.AbstractDiscountedSolver;
import jmarkov.jmdp.solvers.ProbabilitySolver;

public abstract class CTMDP<S extends State, A extends Action>
extends InfiniteMDP<S, A> {
    protected double maxRate = -1.0;
    protected S activeState = null;
    protected CT2DTConverter<S, A> converter;

    public CTMDP(States<S> initial) {
        super(initial);
        Iterator<S> iterator;
        if (initial != null && (iterator = initial.iterator()).hasNext()) {
            State s = (State)iterator.next();
            this.activeState = s;
        }
    }

    @Override
    public StatesSet<S> getAllStates() {
        if (this.states == null) {
            this.states = this.generate();
            this.converter.states = this.states;
        }
        return this.states;
    }

    public void setConverter(CT2DTConverter<S, A> converter) {
        this.converter = converter;
    }

    public double getMaxRate() {
        if (this.maxRate < 0.0) {
            this.states = this.getAllStates();
        }
        return this.maxRate;
    }

    protected StatesSet<S> oneStageReachable(States<S> initSet) {
        StatesSet<State> stts = new StatesSet<State>();
        for (State i : initSet) {
            Actions act = this.feasibleActions(i);
            for (Action a : act) {
                States<State> reached = this.reachable(i, a);
                double tempRate = 0.0;
                for (State j : reached) {
                    stts.add(j);
                    tempRate += this.rate(i, j, a);
                    if (!(tempRate > this.maxRate)) continue;
                    this.maxRate = tempRate;
                }
            }
        }
        return stts;
    }

    @Override
    protected StatesSet<S> generate() {
        StatesSet unexplored = new StatesSet(this.initial);
        StatesSet<State> explored = new StatesSet<State>();
        long initialTime = System.currentTimeMillis();
        while (unexplored.size() > 0) {
            StatesSet<State> stts = this.oneStageReachable(unexplored);
            for (State s : unexplored) {
                explored.add(s);
            }
            for (State s : explored) {
                stts.remove(s);
            }
            unexplored = stts;
        }
        this.explorationTime = System.currentTimeMillis() - initialTime;
        this.maxRate *= 1.1;
        this.debug(1, String.valueOf(explored.size()) + " states found.\n");
        this.numStates = explored.numerateStates();
        return explored;
    }

    public ValueFunction<S> getSteadyStateProbabilities() throws SolverException {
        if (this.probabilitySolver == null) {
            DecisionRule dr = this.getOptimalPolicy().getDecisionRule();
            this.probabilitySolver = new ProbabilitySolver(this, dr);
        }
        if (!this.probabilitySolver.isSolved()) {
            this.probabilitySolver.solve();
            this.probability = this.probabilitySolver.getProbability();
        }
        return this.probability;
    }

    public Solution<S, A> solve(double interestRate) throws SolverException {
        if (!(this.getSolver() instanceof AbstractDiscountedSolver)) {
            this.setSolver(this.getDefaultDiscountedSolver(interestRate));
        }
        ((AbstractDiscountedSolver)this.getSolver()).setInterestRate(interestRate);
        return this.getSolver().solve();
    }

    public abstract double lumpCost(S var1, A var2);

    public abstract double continuousCost(S var1, A var2);

    public abstract States<S> reachable(S var1, A var2);

    public abstract double rate(S var1, S var2, A var3);
}

