/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmarkov.DebugReporter;
import jmarkov.MarkovProcess;
import jmarkov.gui.GuiUtils;
import jmarkov.gui.InfoPanel;
import jmarkov.gui.MarkovClassLoader;
import jmarkov.gui.MarkovFileOpenDialog;
import jmarkov.gui.MatrixPanel;
import jmarkov.gui.SparseMatrixPanel;
import jmarkov.gui.SwingWorker;
import jmarkov.gui.TextPanel;

public class MarkovGUI
extends JFrame
implements ChangeListener,
ComponentListener,
ActionListener {
    private static final long serialVersionUID = 1969L;
    MarkovProcess<?, ?> mp = null;
    MarkovClassLoader cld = null;
    private JPanel mainContentPane = null;
    private JSplitPane splitPane = null;
    private JPanel statusBar = null;
    private JToolBar toolbar = null;
    private TextPanel outTextPanel = null;
    private TextPanel dbgTextPanel = null;
    private JTabbedPane tbpTop = null;
    private JLabel lblStatus = null;
    private JProgressBar progBar = null;
    private JMenuBar menuBar = null;
    private JMenu controlMenu = null;
    private JMenu editMenu = null;
    private JMenu optionsMenu = null;
    private JPanel mainTabPane = null;
    private InfoPanel pnlBrowse;
    private InfoPanel pnlStates;
    private InfoPanel pnlRates;
    private InfoPanel pnlMOPs;
    private InfoPanel pnlEvents;
    private InfoPanel pnlTransient;
    private TextPanel pnlDesc;
    private JLabel lblClass;
    private Action accGo;
    private Action accStep;
    private Action accPause;
    private Action accStop;
    private Action accReStart;
    private Action accLoad;
    private Action accReload;
    private Action accUnload;
    private Action accExit;
    private JSpinner spnDebug;
    private Timer timer = new Timer(500, this);
    private JMenu fileMenu = null;
    private DebugReporter reporter = null;
    private MarkovFileOpenDialog mfod = null;
    private String[] lastClassesLoaded = null;
    private boolean allowedToRun = true;
    boolean oneStep = false;

    public MarkovGUI(MarkovProcess mp) {
        this();
        this.loadMP(mp);
    }

    public MarkovGUI() throws HeadlessException {
        super("JMarkov -- No Model Loaded");
        this.initialize();
    }

    private void initialize() {
        this.initActions();
        this.mainContentPane = this.getMainContentPane();
        this.setContentPane(this.getMainContentPane());
        this.setLocationByPlatform(true);
        System.setProperty("java.awt.Window.locationByPlatform", "true");
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            GuiUtils.changeLook("com.sun.java.swing.plaf.windows.WindowsLookAndFeel", this);
        }
        this.setSize(800, 500);
        this.setPreferredSize(new Dimension(800, 500));
        this.setJMenuBar(this.getTheMenuBar());
        this.setDefaultCloseOperation(2);
        this.outTextPanel.captureStandardOut();
        this.updateStatus();
        this.pack();
        this.setVisible(true);
    }

    public boolean isAllowedToRun() {
        return this.allowedToRun;
    }

    private JPanel getMainContentPane() {
        if (this.mainContentPane == null) {
            this.mainContentPane = new JPanel();
            this.mainContentPane.setLayout(new BorderLayout());
            this.outTextPanel = new TextPanel("Output");
            this.mainContentPane.add((Component)this.getToolBar(), "North");
            this.mainContentPane.add((Component)this.getSplitPane(), "Center");
            this.mainContentPane.add((Component)this.getStatusBar(), "South");
            this.menuBar = this.getTheMenuBar();
            this.setJMenuBar(this.menuBar);
        }
        return this.mainContentPane;
    }

    private JPanel getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new JPanel();
            this.statusBar.setLayout(new GridLayout(1, 2, 10, 10));
            this.lblStatus = new JLabel();
            this.progBar = this.getProgressBar();
            this.statusBar.add(this.lblStatus);
            this.statusBar.add(this.progBar);
        }
        return this.statusBar;
    }

    private JProgressBar getProgressBar() {
        if (this.progBar == null) {
            this.progBar = new JProgressBar();
            this.progBar.setStringPainted(true);
            this.progBar.setString("");
        }
        return this.progBar;
    }

    private JMenuBar getTheMenuBar() {
        if (this.menuBar == null) {
            GuiUtils.createActionTable(this.outTextPanel.txtArea);
            this.editMenu = this.getEditMenu();
            this.controlMenu = this.getControlMenu();
            this.optionsMenu = this.getOptionsMenu();
            this.menuBar = new JMenuBar();
            this.menuBar.add(this.getFileMenu());
            this.menuBar.add(this.editMenu);
            this.menuBar.add(this.controlMenu);
            this.menuBar.add(this.optionsMenu);
        }
        return this.menuBar;
    }

    private JTabbedPane getUpperTabPane() {
        if (this.tbpTop == null) {
            this.tbpTop = new JTabbedPane();
            this.lblClass = GuiUtils.fancyLabel("Class:", "");
            this.mainTabPane = this.getMainTabPane();
            this.tbpTop.addTab("Main", null, this.mainTabPane, "Main Information");
            this.pnlBrowse = new SparseMatrixPanel(true);
            this.pnlBrowse.addComponentListener(this);
            this.tbpTop.addTab("Browse", null, this.pnlBrowse, "Browse the model");
            this.pnlStates = new TextPanel("States");
            this.pnlStates.addComponentListener(this);
            this.tbpTop.addTab("States", null, this.pnlStates, "States information");
            this.pnlRates = new MatrixPanel();
            this.pnlRates.addComponentListener(this);
            this.tbpTop.addTab("Rates", null, this.pnlRates, "Transition Rates information");
            this.pnlMOPs = new TextPanel("Measures of Performance");
            this.pnlMOPs.addComponentListener(this);
            this.pnlTransient = new TextPanel("Transient Bahavior. Not Implemented yet.");
            this.tbpTop.addTab("MOPs", null, this.pnlMOPs, "Measures of performance");
            this.pnlEvents = new TextPanel("Events Rates");
            this.pnlEvents.addComponentListener(this);
            this.tbpTop.addTab("Events", null, this.pnlEvents, "Events Rates");
            this.tbpTop.addTab("Transient", null, this.pnlTransient, "Transient Analisys");
            this.tbpTop.addTab("Output", null, this.outTextPanel, "Output");
            this.tbpTop.setSelectedIndex(0);
            this.tbpTop.setPreferredSize(new Dimension(500, 200));
        }
        return this.tbpTop;
    }

    private JPanel getMainTabPane() {
        if (this.mainTabPane == null) {
            this.mainTabPane = new JPanel();
            this.mainTabPane.setLayout(new BorderLayout());
            this.mainTabPane.add((Component)this.lblClass, "North");
            this.pnlDesc = new TextPanel("Description:");
            this.mainTabPane.add((Component)this.pnlDesc, "Center");
        }
        return this.mainTabPane;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.dbgTextPanel = new TextPanel("Debug Info");
            this.tbpTop = this.getUpperTabPane();
            this.splitPane = new JSplitPane();
            this.splitPane.setOrientation(0);
            this.splitPane.setTopComponent(this.tbpTop);
            this.splitPane.setBottomComponent(this.dbgTextPanel);
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setResizeWeight(1.0);
        }
        return this.splitPane;
    }

    private JMenu getControlMenu() {
        this.controlMenu = new JMenu("Control");
        JMenuItem menuItem = null;
        Action[] actions = new Action[]{this.accGo, this.accPause, this.accReStart, this.accStop};
        int i = 0;
        while (i < actions.length) {
            menuItem = new JMenuItem(actions[i]);
            this.controlMenu.add(menuItem);
            ++i;
        }
        return this.controlMenu;
    }

    private JMenu getEditMenu() {
        this.editMenu = new JMenu("Edit");
        this.editMenu.add(GuiUtils.getActionByName("copy-to-clipboard"));
        this.editMenu.addSeparator();
        this.editMenu.add(GuiUtils.getActionByName("select-all"));
        this.editMenu.add(GuiUtils.getActionByName("select-paragraph"));
        return this.editMenu;
    }

    private JToolBar getToolBar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            Commands[] commandsArray = Commands.values();
            int n = commandsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Commands cmd = commandsArray[n2];
                this.toolbar.add(cmd.getButton());
                ++n2;
            }
            Commands.PAUSE.getButton().setVisible(false);
            this.toolbar.addSeparator();
            this.toolbar.add(new JLabel("Debug Level:"));
            this.spnDebug = this.getSpinner();
            this.toolbar.add(this.spnDebug);
            this.toolbar.setFloatable(false);
        }
        return this.toolbar;
    }

    private JSpinner getSpinner() {
        if (this.spnDebug == null) {
            this.spnDebug = new JSpinner(new SpinnerNumberModel(0, 0, 4, 1));
            this.spnDebug.addChangeListener(this);
            this.spnDebug.setMaximumSize(new Dimension(50, 20));
        }
        return this.spnDebug;
    }

    private JMenu getOptionsMenu() {
        if (this.optionsMenu == null) {
            this.optionsMenu = new JMenu("Options");
            JMenu lookItem = new JMenu("Interface look");
            final MarkovGUI frame = this;
            this.optionsMenu.add(lookItem);
            JRadioButtonMenuItem menuItem = null;
            UIManager.LookAndFeelInfo[] looks = UIManager.getInstalledLookAndFeels();
            ButtonGroup group = new ButtonGroup();
            int i = 0;
            while (i < looks.length) {
                menuItem = new JRadioButtonMenuItem(looks[i].getName());
                group.add(menuItem);
                lookItem.add(menuItem);
                menuItem.setActionCommand(looks[i].getClassName());
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GuiUtils.changeLook(e.getActionCommand(), frame);
                        if (MarkovGUI.this.mfod == null) {
                            GuiUtils.changeLook(e.getActionCommand(), MarkovGUI.this.mfod);
                        }
                    }
                });
                if (UIManager.getLookAndFeel().getName() == looks[i].getName()) {
                    menuItem.setSelected(true);
                }
                ++i;
            }
        }
        return this.optionsMenu;
    }

    public void updateStatus() {
        MarkovProcess.Status status = MarkovProcess.Status.NoModel;
        if (this.mp != null) {
            status = this.mp.getStatus();
        }
        boolean goVisible = status != MarkovProcess.Status.RUNNING;
        Commands.GO.getButton().setVisible(goVisible);
        Commands.PAUSE.getButton().setVisible(!goVisible);
        this.accGo.setEnabled(goVisible && (status == MarkovProcess.Status.IDLE || status == MarkovProcess.Status.SUSPENDED));
        this.accPause.setEnabled(!goVisible && status == MarkovProcess.Status.RUNNING);
        this.accStop.setEnabled(status == MarkovProcess.Status.RUNNING);
        this.accStep.setEnabled(status == MarkovProcess.Status.SUSPENDED || status == MarkovProcess.Status.IDLE);
        this.accReStart.setEnabled(status != MarkovProcess.Status.IDLE && status != MarkovProcess.Status.RUNNING && status != MarkovProcess.Status.NoModel);
        this.accLoad.setEnabled(this.mp == null);
        this.accReload.setEnabled(this.lastClassesLoaded != null);
        this.accUnload.setEnabled(this.mp != null);
        String msg = "No model loaded";
        if (this.mp != null) {
            msg = "   " + this.mp.getStatusMsg();
        }
        this.lblStatus.setText(msg);
        this.setTabEnabled(this.pnlDesc, true);
        this.setTabEnabled(this.pnlStates, status == MarkovProcess.Status.GENERATED);
        this.setTabEnabled(this.pnlMOPs, status == MarkovProcess.Status.GENERATED);
        this.setTabEnabled(this.pnlRates, status == MarkovProcess.Status.GENERATED);
        this.setTabEnabled(this.pnlEvents, status == MarkovProcess.Status.GENERATED);
        this.setTabEnabled(this.pnlTransient, false);
        if (status == MarkovProcess.Status.RUNNING) {
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        } else {
            this.progBar.setIndeterminate(false);
            this.progBar.setValue(this.progBar.getMinimum());
        }
        if (status == MarkovProcess.Status.GENERATED) {
            this.progBar.setIndeterminate(false);
            this.progBar.setMaximum(this.mp.getNumStates());
        }
        if (status != MarkovProcess.Status.NoModel) {
            this.spnDebug.setValue(new Integer(this.mp.getDebugLevel()));
        }
    }

    public void cmdExit() {
        this.timer.stop();
        System.exit(0);
    }

    public void cmdGo() {
        Commands.GO.getButton().setVisible(false);
        Commands.PAUSE.getButton().setVisible(true);
        this.accGo.setEnabled(false);
        this.accPause.setEnabled(true);
        this.allowedToRun = true;
        this.timer.start();
        this.progBar.setIndeterminate(true);
        this.oneStep = false;
        this.runModel();
    }

    public void cmdPause() {
        this.allowedToRun = false;
        this.mp.pause();
        this.progBar.setIndeterminate(false);
        this.timer.stop();
    }

    public void cmdReLoad() {
        this.timer.stop();
        this.progBar.setIndeterminate(false);
        this.progBar.setValue(this.progBar.getMinimum());
        this.dbgTextPanel.clear();
        this.pnlDesc.clear();
        this.lblClass.setText("");
        this.setTabEnabled(this.lblClass, true);
        this.tbpTop.setSelectedIndex(0);
        this.unLoadMP();
        this.loadMP(this.lastClassesLoaded);
    }

    public void cmdReStart() {
        this.timer.stop();
        this.progBar.setIndeterminate(false);
        this.progBar.setValue(this.progBar.getMinimum());
        this.mp.reset();
        this.dbgTextPanel.clear();
        this.tbpTop.setSelectedComponent(this.mainTabPane);
    }

    public void cmdStep() {
        this.timer.start();
        this.progBar.setIndeterminate(true);
        this.allowedToRun = true;
        this.oneStep = true;
        this.runModel();
    }

    private void loadMPFromFileDialog() {
        if (this.mfod == null) {
            this.mfod = new MarkovFileOpenDialog(this.reporter, this);
        }
        this.mfod.setVisible(true);
        if (this.mfod.getDialogResult() == MarkovFileOpenDialog.ResultTypes.CANCEL) {
            this.reporter.debug(0, "Action Canceled");
            return;
        }
        String[] files = this.mfod.getFileNames();
        this.loadMP(files);
    }

    public void loadMP(String[] files) {
        Object[] objects = new Object[3];
        File file = null;
        System.gc();
        if (this.cld == null) {
            this.cld = new MarkovClassLoader();
        }
        int i = 0;
        while (i < 3) {
            try {
                if (files[i] != "") {
                    file = new File(files[i]);
                    objects[i] = this.cld.loadFromFile(file, i == 2);
                }
            }
            catch (Exception e) {
                this.reporter.debug(0, e.getMessage());
                JOptionPane.showMessageDialog(this, e.getMessage(), "JMarkov -- Error Opening model from files", 0);
            }
            ++i;
        }
        if (objects[2] instanceof MarkovProcess) {
            this.mp = (MarkovProcess)objects[2];
        }
        if (this.mp != null) {
            this.loadMP(this.mp);
            this.lastClassesLoaded = files;
        }
    }

    public void loadMP(MarkovProcess<?, ?> mp) {
        this.mp = mp;
        int dbgLevel = mp.getDebugLevel();
        mp.setDebugReporter(this.getDebugReporter());
        this.reporter.setDebugLevel(dbgLevel);
        String[] files = new String[3];
        files[0] = this.filePathForClass(mp.getEventClass());
        this.reporter.debug(1, "Event Class file loaded:" + files[0]);
        files[1] = this.filePathForClass(mp.getStateClass());
        this.reporter.debug(1, "State Class file loaded:" + files[1]);
        files[2] = this.filePathForClass(mp.getClass());
        this.reporter.debug(1, "Model Class file loaded:" + files[2]);
        if (this.mfod == null) {
            this.mfod = new MarkovFileOpenDialog(files, this.reporter, this);
        }
        if (files[2] != "") {
            this.lastClassesLoaded = files;
        }
        String className = mp.getClass().getName();
        this.setTitle("JMarkov -- " + className);
        try {
            File file = new File(files[2]);
            Date date = new Date(file.lastModified());
            this.lblClass.setText(String.valueOf(mp.getClass().getName()) + " (" + file.getCanonicalPath() + " -- " + DateFormat.getInstance().format(date) + ")");
        }
        catch (Exception e) {
            this.lblClass.setText(className);
        }
        this.pnlDesc.setText(mp.description());
        this.spnDebug.setValue(new Integer(mp.getDebugLevel()));
        this.tbpTop.setSelectedIndex(0);
        this.updateStatus();
    }

    private String filePathForClass(Class cls) {
        String fileName = "";
        String canonicalName = cls.getCanonicalName();
        String simpleName = cls.getSimpleName();
        String sep = System.getProperty("file.separator");
        StringTokenizer st = new StringTokenizer(canonicalName, ".");
        String className = st.hasMoreTokens() ? st.nextToken() : "";
        while (st.hasMoreTokens()) {
            className = String.valueOf(className) + sep + st.nextToken();
        }
        try {
            URL url = cls.getClassLoader().getResource(String.valueOf(className) + ".class");
            File file = new File(url.toURI());
            String path = String.valueOf(file.getParent()) + sep;
            fileName = String.valueOf(path) + simpleName + ".class";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileName;
    }

    public void unLoadMP() {
        if (this.mp != null) {
            this.mp.clearMOPs();
        }
        this.mp = null;
        this.pnlStates.unloadMP();
        this.pnlRates.unloadMP();
        this.pnlMOPs.unloadMP();
        this.pnlEvents.unloadMP();
        this.pnlTransient.unloadMP();
        this.pnlDesc.unloadMP();
        this.setTitle("JMarkov -- No model loaded");
        this.cld = null;
        System.gc();
    }

    public void updateTxtPanel(TextPanel aPanel) {
        if (this.mp != null) {
            final TextPanel panel = aPanel;
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    TextPanel txtPanel = panel;
                    PrintWriter wtr = null;
                    wtr = new PrintWriter(txtPanel.getStream(), true);
                    txtPanel.setText("");
                    if (txtPanel == MarkovGUI.this.pnlStates) {
                        MarkovGUI.this.mp.printStates(wtr);
                    }
                    if (txtPanel == MarkovGUI.this.pnlMOPs) {
                        MarkovGUI.this.mp.printMOPs(wtr);
                    }
                    if (txtPanel == MarkovGUI.this.pnlEvents) {
                        MarkovGUI.this.mp.printEventsRates(wtr);
                    }
                    return null;
                }

                @Override
                public void finished() {
                    MarkovGUI.this.updateStatus();
                }
            };
            worker.start();
        }
    }

    public DebugReporter getDebugReporter() {
        if (this.reporter == null) {
            this.reporter = new DebugReporter(new PrintWriter(this.dbgTextPanel.getStream(), true));
            this.dbgTextPanel.setAutoShow(true);
        }
        return this.reporter;
    }

    public void runModel() {
        final SwingWorker runWorker = new SwingWorker(){

            @Override
            public Object construct() {
                if (MarkovGUI.this.oneStep) {
                    MarkovGUI.this.mp.goStep();
                } else {
                    MarkovGUI.this.mp.go();
                }
                return null;
            }

            @Override
            public void finished() {
                MarkovGUI.this.updateStatus();
            }
        };
        Runnable modelRunner = new Runnable(){

            @Override
            public void run() {
                runWorker.start();
            }
        };
        SwingUtilities.invokeLater(modelRunner);
    }

    private void initActions() {
        Commands[] commandsArray = Commands.values();
        int n = commandsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Commands cmd = commandsArray[n2];
            cmd.setAction(new ButtonOrMenuUserAction(cmd.getName(), cmd.getIcon(), cmd.getDescription()));
            ++n2;
        }
        this.accGo = Commands.GO.getAction();
        this.accPause = Commands.PAUSE.getAction();
        this.accStep = Commands.STEP.getAction();
        this.accStop = Commands.STOP.getAction();
        this.accReStart = Commands.RESTART.getAction();
        this.accLoad = Commands.LOAD.getAction();
        this.accUnload = Commands.UNLOAD.getAction();
        this.accReload = Commands.RELOAD.getAction();
        this.accExit = Commands.EXIT.getAction();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int level = ((SpinnerNumberModel)((JSpinner)e.getSource()).getModel()).getNumber().intValue();
        this.mp.setDebugLevel(level);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (e.getComponent() instanceof InfoPanel) {
            InfoPanel infoPanel = (InfoPanel)e.getComponent();
            infoPanel.setMP(this.mp);
        }
        if (e.getComponent() instanceof TextPanel) {
            TextPanel txtpanel = (TextPanel)e.getComponent();
            String currentText = null;
            currentText = txtpanel.getText();
            if (currentText == null || currentText.equals("")) {
                txtpanel.setText("Wait...");
                this.updateTxtPanel(txtpanel);
            }
        }
    }

    public void setTabEnabled(JComponent comp, boolean enabl) {
        Container papi = comp.getParent();
        Container nene = comp;
        int idx = -1;
        while (papi != null) {
            if (papi instanceof JTabbedPane) {
                idx = ((JTabbedPane)papi).indexOfComponent(nene);
                ((JTabbedPane)papi).setEnabledAt(idx, enabl);
                try {
                    if (!enabl) {
                        ((TextPanel)nene).clear();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            nene = papi;
            papi = papi.getParent();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof AbstractButton)) {
            MarkovProcess.Status st = this.mp.getStatus();
            this.progBar.setValue((int)this.mp.getProgress());
            if (st != MarkovProcess.Status.RUNNING) {
                this.timer.stop();
                if (st == MarkovProcess.Status.GENERATED) {
                    this.progBar.setValue(this.progBar.getMinimum());
                }
            }
        }
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            Action[] actions;
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            JMenuItem menuItem = null;
            Action[] actionArray = actions = new Action[]{this.accLoad, this.accUnload, this.accReload, this.accExit};
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action ac = actionArray[n2];
                menuItem = new JMenuItem(ac);
                this.fileMenu.add(menuItem);
                ++n2;
            }
        }
        return this.fileMenu;
    }

    public static void main(String[] a) {
        MarkovGUI theGUI = new MarkovGUI();
        theGUI.setVisible(true);
    }

    class ButtonOrMenuUserAction
    extends AbstractAction {
        private static final long serialVersionUID = 1969L;

        public ButtonOrMenuUserAction(String name, Icon icon, String desc, Integer mnemonic) {
            super(name, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public ButtonOrMenuUserAction(String name, Icon icon, String desc) {
            this(name, icon, desc, new Integer(0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Action acc = ((AbstractButton)e.getSource()).getAction();
            if (acc == MarkovGUI.this.accGo) {
                MarkovGUI.this.cmdGo();
            }
            if (acc == MarkovGUI.this.accPause) {
                MarkovGUI.this.cmdPause();
            }
            if (acc == MarkovGUI.this.accStep) {
                MarkovGUI.this.cmdStep();
            }
            if (acc == MarkovGUI.this.accStop) {
                this.cmdStop();
            }
            if (acc == MarkovGUI.this.accReStart) {
                MarkovGUI.this.cmdReStart();
            }
            if (acc == MarkovGUI.this.accLoad) {
                this.cmdLoad();
            }
            if (acc == MarkovGUI.this.accReload) {
                MarkovGUI.this.cmdReLoad();
            }
            if (acc == MarkovGUI.this.accUnload) {
                this.cmdUnload();
            }
            if (acc == MarkovGUI.this.accExit) {
                MarkovGUI.this.cmdExit();
            }
            MarkovGUI.this.updateStatus();
        }

        public void cmdUnload() {
            MarkovGUI.this.timer.stop();
            MarkovGUI.this.progBar.setIndeterminate(false);
            MarkovGUI.this.progBar.setValue(MarkovGUI.this.progBar.getMinimum());
            MarkovGUI.this.dbgTextPanel.clear();
            MarkovGUI.this.pnlDesc.clear();
            MarkovGUI.this.lblClass.setText("No class loaded");
            MarkovGUI.this.setTabEnabled(MarkovGUI.this.lblClass, true);
            MarkovGUI.this.tbpTop.setSelectedIndex(0);
            MarkovGUI.this.unLoadMP();
        }

        public void cmdLoad() {
            MarkovGUI.this.timer.stop();
            MarkovGUI.this.progBar.setIndeterminate(false);
            MarkovGUI.this.progBar.setValue(MarkovGUI.this.progBar.getMinimum());
            MarkovGUI.this.dbgTextPanel.clear();
            MarkovGUI.this.loadMPFromFileDialog();
        }

        public void cmdStop() {
            MarkovGUI.this.timer.stop();
            MarkovGUI.this.progBar.setIndeterminate(false);
            MarkovGUI.this.progBar.setValue(MarkovGUI.this.progBar.getMinimum());
            MarkovGUI.this.allowedToRun = false;
            MarkovGUI.this.mp.pause();
            MarkovGUI.this.mp.reset();
            MarkovGUI.this.tbpTop.setSelectedComponent(MarkovGUI.this.mainTabPane);
        }
    }

    static enum Commands {
        GO("GO", "Play16.gif", "Generates the model"),
        PAUSE("PAUSE", "Pause16.gif", "Pauses Execution of the model"),
        STEP("STEP", "StepForward16.gif", "Generates one step of the model"),
        RESTART("Re-Start", "Rewind16.gif", "Starts over execution"),
        STOP("Stop", "Stop16.gif", "Stops Execution"),
        LOAD("Load", "Import16.gif", "Loads the problem"),
        UNLOAD("Unload", "Export16.gif", "Unloads the problem"),
        RELOAD("Reload", "Refresh16.gif", "Reloads the problem"),
        EXIT("Exit", "Remove16.gif", "Exit JMarkov");

        private Action action;
        private JButton button;
        private ImageIcon icon = null;
        private String name;
        private String description;

        private Commands(String name, String iconFile, String description) {
            try {
                this.icon = GuiUtils.createIcon("/jmarkov/gui/images/" + iconFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.name = name;
            this.description = description;
        }

        public JButton getButton() {
            return this.button;
        }

        public Action getAction() {
            return this.action;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void setAction(Action ac) {
            this.action = ac;
            this.button = GuiUtils.getButton(this.action);
        }
    }
}

