/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.basic;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jmarkov.basic.JMarkovElement;
import jmarkov.basic.State;

public class ValueFunction<S extends State>
implements JMarkovElement {
    private SortedMap<S, Double> valueFunction;
    private String name = "Value Function";

    public ValueFunction() {
        this.valueFunction = new TreeMap<S, Double>();
    }

    public ValueFunction(ValueFunction<S> vf) {
        this.valueFunction = new TreeMap<S, Double>(vf.valueFunction);
        this.name = vf.name;
    }

    public ValueFunction(String name) {
        this.valueFunction = new TreeMap<S, Double>();
        this.name = name;
    }

    public ValueFunction(ValueFunction<S> vf, String name) {
        this.valueFunction = new TreeMap<S, Double>(vf.valueFunction);
        this.name = name;
    }

    public void set(S s, double val) {
        this.valueFunction.put(s, new Double(val));
    }

    public Iterator<Map.Entry<S, Double>> iterator() {
        return this.valueFunction.entrySet().iterator();
    }

    public double get(S s) {
        if (this.valueFunction.containsKey(s)) {
            return (Double)this.valueFunction.get(s);
        }
        this.valueFunction.put(s, new Double(0.0));
        return 0.0;
    }

    public double[] get() {
        int n = this.valueFunction.size();
        double[] values = new double[n];
        Collection<Double> vals = this.valueFunction.values();
        int i = 0;
        for (Double d : vals) {
            values[i++] = d;
        }
        return values;
    }

    public void print(PrintWriter pw, String statesFormat, String valuesFormat) {
        pw.println(String.valueOf(this.name) + ":");
        for (Map.Entry<S, Double> entry : this.valueFunction.entrySet()) {
            pw.printf(String.valueOf(statesFormat) + " : " + valuesFormat, entry.getKey(), entry.getValue());
            pw.println();
        }
    }

    public void print(PrintWriter pw) {
        this.print(pw, "%-12S", "%10.2f");
    }

    @Override
    public String toString() {
        return this.label();
    }

    @Override
    public String label() {
        int size = this.valueFunction.size();
        if (size < 20) {
            return this.valueFunction.toString();
        }
        return "Value funciton with " + size + " states";
    }

    @Override
    public String description() {
        return this.valueFunction.toString();
    }
}

