/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.basic;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jmarkov.basic.JMarkovElement;
import jmarkov.basic.State;
import jmarkov.basic.Transition;
import jmarkov.basic.Transitions;

public final class TransitionsSet<S extends State>
implements JMarkovElement,
Transitions<S> {
    private SortedMap<S, Double> theSet = new TreeMap<S, Double>();

    @Override
    public boolean add(Transition<S> t) {
        return this.theSet.put(t.getState(), t.getRate()) == null;
    }

    @Override
    public boolean add(Transitions<S> trans) {
        boolean result = true;
        for (Transition transition : trans) {
            result &= this.add(transition);
        }
        return result;
    }

    @Override
    public boolean add(S state, double rate) {
        return this.add(new Transition<S>(state, rate));
    }

    @Override
    public double addRate(S state, double rate) {
        double oldVal = this.getRate(state);
        this.add(new Transition<S>(state, oldVal + rate));
        return oldVal;
    }

    @Override
    public double getRate(S state) {
        Double val = (Double)this.theSet.get(state);
        return val == null ? 0.0 : val;
    }

    @Override
    public int size() {
        return this.theSet.size();
    }

    @Override
    public String label() {
        String result = "";
        result = this.size() > 15 ? "Transtions with " + this.theSet.size() + " states." : this.description();
        return result;
    }

    @Override
    public String description() {
        return this.theSet.toString();
    }

    @Override
    public final String toString() {
        return this.label();
    }

    @Override
    public Iterator<Transition<S>> iterator() {
        return new Iterator<Transition<S>>(){
            Iterator<Map.Entry<S, Double>> it;
            {
                this.it = TransitionsSet.this.theSet.entrySet().iterator();
            }

            @Override
            public Transition<S> next() {
                Map.Entry me = this.it.next();
                return new Transition<State>((State)me.getKey(), me.getValue());
            }

            @Override
            public void remove() {
                this.it.remove();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }
        };
    }
}

