/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import examples.jmarkov.QueueMM1N;
import jmarkov.MarkovProcess;
import jmarkov.Utils;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class QueueMM1NTest
extends TestCase {
    private QueueMM1N model = new QueueMM1N(4.0, 2.0, 18);
    private double[] prob = null;
    private int N;

    public static void main(String[] args) {
        TestRunner.run(QueueMM1NTest.class);
    }

    public void testGenerate() {
        this.model.generate();
        QueueMM1NTest.assertTrue((String)"QueueMM1N not generates", (this.model.getStatus() == MarkovProcess.Status.GENERATED ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        double lam = this.model.getLambda();
        double mu = this.model.getMu();
        this.N = this.model.getMax();
        this.prob = new double[this.N + 1];
        this.prob[0] = 1.0;
        double sum = 1.0;
        int i = 1;
        while (i <= this.N) {
            this.prob[i] = this.prob[i - 1] * lam / mu;
            sum += this.prob[i];
            ++i;
        }
        i = 0;
        while (i <= this.N) {
            this.prob[i] = this.prob[i] / sum;
            ++i;
        }
        this.model.setDebugLevel(0);
    }

    public void tearDown() {
        this.model = null;
    }

    public void testGetSteadyState() throws Exception {
        Utils.assertArrayEquals("Steady probabilities not equal in model MM1N", this.prob, this.model.getSteadyState(), 1.0E-5);
    }

    public void testGetMOPsAvg() throws Exception {
        double ldaEff = this.model.getLambda() * (1.0 - this.prob[this.model.getMax()]);
        double sum = 0.0;
        double sumQ = 0.0;
        int i = 1;
        while (i <= this.N) {
            sum += (double)i * this.prob[i];
            sumQ += (double)(i - 1) * this.prob[i];
            ++i;
        }
        double L = sum;
        double Lq = sumQ;
        double rho = ldaEff / this.model.getMu();
        double[] mops = this.model.getMOPsAvg();
        Utils.assertArrayEquals("MOPS not equal: ", new double[]{L, Lq, rho}, mops, 1.0E-5);
    }

    public void testGetEventRates() throws Exception {
        double ldaEff = this.model.getLambda() * (1.0 - this.prob[this.model.getMax()]);
        QueueMM1NTest.assertEquals((String)"Arrival rate not equal: ", (double)ldaEff, (double)this.model.getEventRate(0), (double)1.0E-5);
    }
}

