/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.InvLevel;
import examples.jmdp.Order;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.FiniteDP;
import jmarkov.jmdp.solvers.FiniteSolver;

public class WagnerWhitin
extends FiniteDP<InvLevel, Order> {
    int lastStage;
    int maxInventory;
    int maxBackorders;
    int truckSize;
    double K;
    double b;
    double h;
    double price;
    double cost;
    int[] demand;

    public WagnerWhitin(int initialInventory, int lastStage, int maxInventory, int maxBackorders, int truckSize, double K, double b, double price, double cost, double h, int[] demand) {
        super(new StatesSet<InvLevel>(new InvLevel(initialInventory)), lastStage);
        this.maxInventory = maxInventory;
        this.maxBackorders = maxBackorders;
        this.truckSize = truckSize;
        this.K = K;
        this.b = b;
        this.h = h;
        this.demand = demand;
        this.price = price;
        this.cost = cost;
        this.init();
    }

    void init() {
        Order[] acts = new Order[this.maxInventory + this.maxBackorders + 1];
        InvLevel[] ssts = new InvLevel[this.maxInventory + this.maxBackorders + 1];
        int k = 0;
        while (k < this.maxInventory + this.maxBackorders + 1) {
            acts[k] = new Order(k);
            ssts[k] = new InvLevel(k - this.maxBackorders);
            ++k;
        }
    }

    private double holdingCost(int x) {
        return x > 0 ? this.h * this.cost * (double)x : 0.0;
    }

    private double orderCost(int x) {
        return x > 0 ? Math.ceil((double)x / (double)this.truckSize) * this.K : 0.0;
    }

    double backorderCost(int x) {
        return x < 0 ? -this.b * (double)x : 0.0;
    }

    double lostOrderCost(int x, int t) {
        return x + this.maxBackorders < this.demand[t] ? (this.price - this.cost) * (double)(this.demand[t] - x - this.maxBackorders) : 0.0;
    }

    public double getOptimalCost(int inventory) throws SolverException {
        return this.getOptimalValueFunction().get(new InvLevel(inventory));
    }

    @Override
    public double immediateCost(InvLevel i, Order a, int t) {
        int s = i.getLevel();
        int o = a.getSize();
        return this.lostOrderCost(o, t) + this.orderCost(o) + this.holdingCost(s + o) + this.backorderCost(s + o);
    }

    @Override
    public double finalCost(InvLevel i) {
        return 0.0;
    }

    @Override
    public Actions<Order> feasibleActions(InvLevel i, int t) {
        ActionsSet<Order> actionSet = new ActionsSet<Order>();
        int min_order = Math.max(-this.maxBackorders - i.getLevel() + this.demand[t], 0);
        int max_order = this.maxInventory - i.getLevel() + this.demand[t];
        int n = min_order;
        while (n <= max_order) {
            actionSet.add(new Order(n));
            ++n;
        }
        return actionSet;
    }

    @Override
    public InvLevel destination(InvLevel i, Order a, int t) {
        int o = a.getSize();
        int iLevel = i.getLevel();
        return new InvLevel(Math.max(iLevel + o - this.demand[t], -this.maxBackorders));
    }

    public static void main(String[] a) throws Exception {
        int lastStage = 12;
        int maxInventory = 15;
        int maxBackorders = 5;
        int truckSize = 6;
        double K = 500.0;
        double b = 2000.0;
        double p = 22000.0;
        double c = 20000.0;
        double h = Math.pow(1.3, 0.019230769230769232) - 1.0;
        int[] nArray = new int[12];
        nArray[0] = 10;
        nArray[1] = 4;
        nArray[2] = 3;
        nArray[3] = 6;
        nArray[4] = 3;
        nArray[5] = 2;
        nArray[7] = 1;
        nArray[8] = 7;
        nArray[9] = 3;
        nArray[10] = 4;
        nArray[11] = 5;
        int[] demand = nArray;
        WagnerWhitin prob = new WagnerWhitin(0, lastStage, maxInventory, maxBackorders, truckSize, K, b, p, c, h, demand);
        FiniteSolver<InvLevel, Order> theSolver = new FiniteSolver<InvLevel, Order>(prob);
        prob.setSolver(theSolver);
        prob.solve();
        prob.getSolver().setPrintValueFunction(true);
        prob.printSolution();
        prob.getOptimalCost(0);
    }
}

