/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import Jama.Matrix;
import examples.jmdp.InvLevel;
import examples.jmdp.Order;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.DecisionRule;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.solvers.PolicyIterationSolverAvg;

public class ControlProdNonEvents
extends DTMDP<InvLevel, Order> {
    private int maxInventory;
    private double fixedCost;
    private double cost;
    private double price;
    private double holdingCost;
    private double[] demPMF;
    private double[] demCCDF;
    private double[] demandLoss1;
    private double expDemand;
    private double interestRate;
    private Actions actions;

    public ControlProdNonEvents(int maxInventory, double fixedCost, double cost, double price, double holdingCost, double interestRate, double expDemand) {
        super(new InvLevel(0));
        this.maxInventory = maxInventory;
        this.fixedCost = fixedCost;
        this.cost = cost;
        this.price = price;
        this.holdingCost = holdingCost;
        this.expDemand = expDemand;
        this.interestRate = interestRate;
        this.demPMF = new double[maxInventory + 1];
        this.demCCDF = new double[maxInventory + 1];
        this.demandLoss1 = new double[maxInventory + 1];
        this.init();
    }

    public double getValueFunction(int invLevel) throws SolverException {
        return this.getOptimalValueFunction().get(new InvLevel(invLevel));
    }

    public int getOptimalOrderSize(int invLevel) {
        try {
            return ((Order)this.getOptimalPolicy().getDecisionRule().getAction(new InvLevel(invLevel))).getSize();
        }
        catch (SolverException e) {
            return -1;
        }
    }

    public int[] getOptimalOrderSize() {
        StatesSet stts = this.getAllStates();
        int n = stts.size();
        int[] acts = new int[n];
        try {
            DecisionRule dr = this.getOptimalPolicy().getDecisionRule();
            int i = 0;
            while (i < n) {
                acts[i] = ((Order)dr.getAction(new InvLevel(i))).getSize();
                ++i;
            }
        }
        catch (SolverException solverException) {
            // empty catch block
        }
        return acts;
    }

    private double orderCost(int x) {
        return x > 0 ? this.fixedCost + this.cost * (double)x : 0.0;
    }

    private void initializeProbabilities() {
        double p;
        double cdf = p = Math.exp(-this.expDemand);
        this.demPMF[0] = p;
        this.demCCDF[0] = 1.0;
        this.demandLoss1[0] = this.expDemand;
        int i = 1;
        while (i <= this.maxInventory) {
            this.demCCDF[i] = 1.0 - cdf;
            p = p * this.expDemand / (double)i;
            this.demPMF[i] = p;
            this.demandLoss1[i] = (this.expDemand - (double)i) * (1.0 - (cdf += p)) + this.expDemand * p;
            ++i;
        }
    }

    @Override
    public States<InvLevel> reachable(InvLevel i, Order a) {
        StatesSet<InvLevel> statesSet = new StatesSet<InvLevel>();
        int maxInv = i.getLevel() + a.getSize();
        int n = 0;
        while (n <= maxInv) {
            statesSet.add(new InvLevel(n));
            ++n;
        }
        return statesSet;
    }

    @Override
    public double prob(InvLevel i, InvLevel j, Order a) {
        int iLevel = i.getLevel();
        int jLevel = j.getLevel();
        int orderSize = a.getSize();
        if (jLevel > 0 && jLevel <= orderSize + iLevel && orderSize + iLevel <= this.maxInventory) {
            return this.demPMF[orderSize + iLevel - jLevel];
        }
        if (orderSize + iLevel <= this.maxInventory && jLevel == 0) {
            return this.demCCDF[Math.max(orderSize + iLevel, 0)];
        }
        throw new IllegalArgumentException("'prob' Called on non-reachable state: i=" + iLevel + ",j=" + jLevel + " ,a=" + orderSize);
    }

    @Override
    public double immediateCost(InvLevel i, Order a) {
        int orderSize;
        int iLevel = i.getLevel();
        int available = iLevel + (orderSize = a.getSize());
        if (available > this.maxInventory) {
            throw new IllegalArgumentException("cost called on unavailable action!");
        }
        double expectedSales = this.expDemand - this.demandLoss1[available];
        double netProfit = this.price * expectedSales - this.orderCost(a.getSize()) - this.holdingCost * (double)i.getLevel();
        return -netProfit;
    }

    void init() {
        Order[] acts = new Order[this.maxInventory + 1];
        InvLevel[] ssts = new InvLevel[this.maxInventory + 1];
        int k = 0;
        while (k <= this.maxInventory) {
            acts[k] = new Order(k);
            ssts[k] = new InvLevel(k);
            ++k;
        }
        this.states = new StatesSet<InvLevel[]>(ssts);
        this.actions = new ActionsSet<Order[]>(acts);
        this.initializeProbabilities();
    }

    @Override
    public Actions<Order> feasibleActions(InvLevel i) {
        int max = this.maxInventory - i.getLevel();
        Order[] vec = new Order[max + 1];
        int k = 0;
        while (k <= max) {
            vec[k] = new Order(k);
            ++k;
        }
        return new ActionsSet<Order[]>(vec);
    }

    public void printMatrices() {
        double[][] cost = new double[this.maxInventory + 1][this.maxInventory + 1];
        double[][][] prb = new double[this.maxInventory + 1][this.maxInventory + 1][this.maxInventory + 1];
        int i = 0;
        while (i <= this.maxInventory) {
            int a = 0;
            while (a + i <= this.maxInventory) {
                cost[i][a] = this.immediateCost(new InvLevel(i), new Order(a));
                int invMax = i + a;
                int j = 0;
                while (j <= invMax) {
                    prb[a][i][j] = this.prob(new InvLevel(i), new InvLevel(j), new Order(a));
                    ++j;
                }
                ++a;
            }
            ++i;
        }
        new Matrix(cost).print(8, 2);
        int a = 0;
        while (a < this.maxInventory) {
            new Matrix(prb[a]).print(10, 6);
            ++a;
        }
        new Matrix((double[][])new double[][]{this.demPMF}).print(10, 6);
        new Matrix((double[][])new double[][]{this.demCCDF}).print(10, 6);
        new Matrix((double[][])new double[][]{this.demandLoss1}).print(10, 6);
    }

    public static void main(String[] a) throws SolverException {
        int M = 4;
        double K = 500.0;
        double cost = 400.0;
        double price = 1000.0;
        double holdingCost = 80.0;
        double interestRate = 0.1;
        double demandMean = 4.0;
        ControlProdNonEvents prob = new ControlProdNonEvents(M, K, cost, price, holdingCost, interestRate, demandMean);
        prob.printMatrices();
        PolicyIterationSolverAvg<InvLevel, Order> solv = new PolicyIterationSolverAvg<InvLevel, Order>(prob);
        prob.setSolver(solv);
        solv.setPrintGain(true);
        prob.setDebugLevel(4);
        prob.getSolver().setPrintValueFunction(true);
        prob.solve();
        prob.printSolution();
    }
}

