/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.BankQueues;
import examples.jmdp.BankServers;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.ValueFunction;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.CTMDP;
import jmarkov.jmdp.solvers.ValueIterationSolver;

public class Bank2Queues
extends CTMDP<BankQueues, BankServers> {
    double clientMinuteCost;
    double userMinuteCost;
    double clientProbability;
    double lambda;
    double mu;
    int maxCapacity;
    int maxServers;

    public Bank2Queues(States<BankQueues> initial, double clientMinuteCost, double userMinuteCost, double clientProbability, double lambda, double mu, int maxCapacity, int maxServers) {
        super(initial);
        this.clientMinuteCost = clientMinuteCost;
        this.userMinuteCost = userMinuteCost;
        this.clientProbability = clientProbability;
        this.lambda = lambda;
        this.mu = mu;
        this.maxCapacity = maxCapacity;
        this.maxServers = maxServers;
    }

    public double computeMOPs(BankQueues i, Measure m) {
        switch (m) {
            case CLIENT_QUEUE_LENGTH: {
                return i.getClients() - Math.min(i.getClients(), i.getClientServers());
            }
            case USER_QUEUE_LENGTH: {
                return i.getUsers() - Math.min(i.getUsers(), this.maxServers - i.getClientServers());
            }
            case EFFECTIVE_LAMBDA: {
                return i.getClients() + i.getUsers() < this.maxCapacity ? 1 : 0;
            }
            case CLIENT_SERVER_UTILIZATION: {
                return i.getClients() > i.getClientServers() ? 1 : 0;
            }
            case USER_SERVER_UTILIZATION: {
                return i.getUsers() > this.maxServers - i.getClientServers() ? 1 : 0;
            }
        }
        return 0.0;
    }

    @Override
    public double lumpCost(BankQueues i, BankServers a) {
        return 0.0;
    }

    @Override
    public double continuousCost(BankQueues i, BankServers a) {
        int waitingClients = Math.max(i.getClients() - i.getClientServers(), 0);
        int waitingUsers = Math.max(i.getUsers() - (this.maxServers - i.getClientServers()), 0);
        return this.clientMinuteCost * (double)waitingClients + this.userMinuteCost * (double)waitingUsers;
    }

    @Override
    public States<BankQueues> reachable(BankQueues i, BankServers a) {
        int[] temp;
        StatesSet<BankQueues> set = new StatesSet<BankQueues>();
        int total = i.getClients() + i.getUsers();
        int servers = i.getClientServers();
        int ac = a.getClientServers();
        if (ac <= 0 && i.getClients() > 0 && servers > 1) {
            temp = new int[]{i.getClients() - 1, i.getUsers(), servers + ac};
            set.add(new BankQueues(temp));
        }
        if (ac >= 0 && i.getUsers() > 0 && servers < this.maxServers - 1) {
            temp = new int[]{i.getClients(), i.getUsers() - 1, servers + ac};
            set.add(new BankQueues(temp));
        }
        if (ac == 0 && total < this.maxCapacity && servers > 0) {
            temp = new int[]{i.getClients() + 1, i.getUsers(), servers};
            set.add(new BankQueues(temp));
        }
        if (ac == 0 && total < this.maxCapacity && servers < this.maxServers) {
            temp = new int[]{i.getClients(), i.getUsers() + 1, servers};
            set.add(new BankQueues(temp));
        }
        return set;
    }

    @Override
    public double rate(BankQueues i, BankQueues j, BankServers a) {
        int clients = i.getClients();
        int users = i.getUsers();
        int clientServers = i.getClientServers();
        int jClients = j.getClients();
        int jUsers = j.getUsers();
        if (jClients - clients > 0) {
            if (a.getClientServers() == 0) {
                return this.lambda * this.clientProbability;
            }
        } else if (jUsers - users > 0 && a.getClientServers() == 0) {
            return this.lambda * (1.0 - this.clientProbability);
        }
        if (clients - jClients > 0 && clientServers > 0) {
            if (a.getClientServers() <= 0) {
                return (double)Math.min(clients, clientServers) * this.mu;
            }
        } else if (users - jUsers > 0 && clientServers < this.maxServers && a.getClientServers() >= 0) {
            return (double)Math.min(users, this.maxServers - clientServers) * this.mu;
        }
        return 0.0;
    }

    @Override
    public Actions<BankServers> feasibleActions(BankQueues i) {
        int[] temp;
        ActionsSet<BankServers> set = new ActionsSet<BankServers>();
        if (i.getClients() > 0 && i.getClientServers() > 1) {
            temp = new int[]{-1};
            set.add(new BankServers(temp));
        }
        if (i.getUsers() > 0 && i.getClientServers() < this.maxServers - 1) {
            temp = new int[]{1};
            set.add(new BankServers(temp));
        }
        temp = new int[1];
        set.add(new BankServers(temp));
        return set;
    }

    public double length() throws SolverException {
        double queue = 0.0;
        ValueFunction probs = this.getSteadyStateProbabilities();
        Iterator it = probs.iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            queue += e.getValue() * this.computeMOPs((BankQueues)e.getKey(), Measure.CLIENT_QUEUE_LENGTH);
        }
        return queue;
    }

    public static void main(String[] args) throws SolverException {
        int maxCapacity = 5;
        int maxServers = 4;
        double clientMinuteCost = 10.0;
        double userMinuteCost = 4.0;
        double clientProbability = 0.4;
        double lambda = maxServers * 2;
        double mu = 2.0;
        int[] nArray = new int[3];
        nArray[2] = 1;
        int[] initState = nArray;
        StatesSet<BankQueues> init = new StatesSet<BankQueues>(new BankQueues(initState));
        Bank2Queues prob = new Bank2Queues(init, clientMinuteCost, userMinuteCost, clientProbability, lambda, mu, maxCapacity, maxServers);
        ValueIterationSolver<BankQueues, BankServers> solv = new ValueIterationSolver<BankQueues, BankServers>(prob, 0.06);
        solv.useGaussSeidel(false);
        prob.solve();
        prob.printSolution();
        prob.getOptimalValueFunction().print(new PrintWriter(System.out, true));
    }

    protected static enum Measure {
        CLIENT_QUEUE_LENGTH,
        USER_QUEUE_LENGTH,
        EFFECTIVE_LAMBDA,
        CLIENT_SERVER_UTILIZATION,
        USER_SERVER_UTILIZATION;

    }
}

