/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.QueueMH2k1Event;
import examples.jmarkov.QueueMH2k1State;
import jmarkov.GeomProcess;
import jmarkov.GeomRelState;
import jmarkov.basic.StatesSet;

public class QueueMH2k1
extends GeomProcess<QueueMH2k1State, QueueMH2k1Event> {
    final int ARRIVAL1 = 0;
    final int ARRIVAL2 = 1;
    final int SERVICE1 = 2;
    final int DEPARTURE = 3;
    private double lambda1;
    private double lambda2;
    private double mu1;
    private double mu2;

    public QueueMH2k1(int lambda1, int lambda2, double mu1, double mu2) {
        super(new QueueMH2k1State(0), QueueMH2k1Event.getAllEvents());
        this.lambda1 = lambda1;
        this.lambda2 = lambda2;
        this.mu1 = mu1;
        this.mu2 = mu2;
    }

    public QueueMH2k1() {
        this(3, 2, 5.0, 4.0);
    }

    @Override
    public boolean active(QueueMH2k1State i, int absLevel, QueueMH2k1Event e) {
        boolean result = false;
        switch (e.type) {
            case 0: {
                result = absLevel == 0;
                break;
            }
            case 1: {
                result = absLevel != 0;
                break;
            }
            case 2: {
                result = i.getServerStatus() == 1;
                break;
            }
            case 3: {
                result = i.getServerStatus() == 2;
            }
        }
        return result;
    }

    @Override
    public GeomRelState<QueueMH2k1State>[] dests(QueueMH2k1State i, int absLevel, QueueMH2k1Event e) {
        int newy = i.getServerStatus();
        int rLevel = 0;
        switch (e.type) {
            case 0: {
                newy = 1;
                rLevel = 1;
                break;
            }
            case 1: {
                rLevel = 1;
                break;
            }
            case 2: {
                ++newy;
                break;
            }
            case 3: {
                if (absLevel == 1) {
                    newy = 0;
                    break;
                }
                rLevel = -1;
                --newy;
            }
        }
        QueueMH2k1State newSubState = new QueueMH2k1State(newy);
        GeomRelState<QueueMH2k1State> s = e.type == 3 && absLevel == 1 ? new GeomRelState<QueueMH2k1State>(newSubState) : new GeomRelState<QueueMH2k1State>(newSubState, rLevel);
        StatesSet<GeomRelState<QueueMH2k1State>> statesSet = new StatesSet<GeomRelState<QueueMH2k1State>>(s);
        return (GeomRelState[])statesSet.toStateArray();
    }

    @Override
    public double rate(QueueMH2k1State i, int iLevel, QueueMH2k1State j, int jLevel, QueueMH2k1Event e) {
        double result = 0.0;
        switch (e.type) {
            case 0: {
                result = this.lambda1;
                break;
            }
            case 1: {
                result = this.lambda2;
                break;
            }
            case 2: {
                result = this.mu1;
                break;
            }
            case 3: {
                result = this.mu2;
            }
        }
        return result;
    }

    @Override
    public String description() {
        String stg = "System M/E(k)/1";
        stg = String.valueOf(stg) + "\nLambda 1 = " + this.lambda1;
        stg = String.valueOf(stg) + "\nLambda 2 = " + this.lambda2;
        stg = String.valueOf(stg) + "\nMu 1     = " + this.mu1;
        stg = String.valueOf(stg) + "\nMu 2     = " + this.mu2;
        return stg;
    }

    public static void main(String[] a) {
        QueueMH2k1 theQueue = new QueueMH2k1(7, 4, 9.0, 9.0);
        theQueue.setDebugLevel(0);
        theQueue.showGUI();
        theQueue.printAll();
    }
}

