/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.QueueMEk1Event;
import examples.jmarkov.QueueMEk1State;
import jmarkov.GeomProcess;
import jmarkov.GeomRelState;
import jmarkov.basic.StatesSet;

public class QueueMEk1
extends GeomProcess<QueueMEk1State, QueueMEk1Event> {
    final int ARRIVAL1 = 0;
    final int ARRIVAL2 = 1;
    final int SERVICE1 = 2;
    final int DEPARTURE = 3;
    private double lambda1;
    private double lambda2;
    private double[] mu;

    public QueueMEk1(int lambda1, int lambda2, double[] mu) {
        super(new QueueMEk1State(0, mu.length), QueueMEk1Event.getAllEvents(mu.length));
        this.lambda1 = lambda1;
        this.lambda2 = lambda2;
        this.mu = mu;
    }

    public QueueMEk1() {
        this(3, 2, new double[]{9.0, 9.0});
    }

    public int getNumStages() {
        return this.mu.length;
    }

    @Override
    public boolean active(QueueMEk1State i, int absLevel, QueueMEk1Event e) {
        boolean result = false;
        switch (e.type) {
            case 0: {
                result = absLevel == 0;
                break;
            }
            case 1: {
                result = absLevel != 0;
                break;
            }
            case 2: {
                result = i.getServerStatus() == e.stage;
                break;
            }
            case 3: {
                result = i.getServerStatus() == this.getNumStages();
            }
        }
        return result;
    }

    @Override
    public GeomRelState<QueueMEk1State>[] dests(QueueMEk1State i, int absLevel, QueueMEk1Event e) {
        int newStatus = i.getServerStatus();
        int rLevel = 0;
        switch (e.type) {
            case 0: {
                newStatus = 1;
                rLevel = 1;
                break;
            }
            case 1: {
                rLevel = 1;
                break;
            }
            case 2: {
                ++newStatus;
                break;
            }
            case 3: {
                if (absLevel == 1) {
                    newStatus = 0;
                    break;
                }
                rLevel = -1;
                newStatus = 1;
            }
        }
        QueueMEk1State newSubState = new QueueMEk1State(newStatus, this.getNumStages());
        GeomRelState<QueueMEk1State> s = e.type == 3 && absLevel == 1 ? new GeomRelState<QueueMEk1State>(newSubState) : new GeomRelState<QueueMEk1State>(newSubState, rLevel);
        StatesSet<GeomRelState<QueueMEk1State>> statesSet = new StatesSet<GeomRelState<QueueMEk1State>>(s);
        return (GeomRelState[])statesSet.toStateArray();
    }

    @Override
    public double rate(QueueMEk1State i, int iLevel, QueueMEk1State j, int jLevel, QueueMEk1Event e) {
        double result = 0.0;
        switch (e.type) {
            case 0: {
                result = this.lambda1;
                break;
            }
            case 1: {
                result = this.lambda2;
                break;
            }
            case 2: {
                result = this.mu[e.stage - 1];
                break;
            }
            case 3: {
                result = this.mu[this.getNumStages() - 1];
            }
        }
        return result;
    }

    @Override
    public String description() {
        String stg = "System M/E(k)/1";
        stg = String.valueOf(stg) + "\nLambda 1 = " + this.lambda1;
        stg = String.valueOf(stg) + "\nLambda 2 = " + this.lambda2;
        int i = 1;
        while (i <= this.getNumStages()) {
            stg = String.valueOf(stg) + "\nMu " + i + "     = " + this.mu[i - 1];
            ++i;
        }
        return stg;
    }

    public static void main(String[] a) {
        QueueMEk1 theQueue = new QueueMEk1(7, 4, new double[]{20.0, 20.0, 20.0});
        theQueue.setDebugLevel(0);
        theQueue.printAll();
    }
}

