/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.KanbanEvent;
import examples.jmarkov.KanbanState;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;

public class Kanban
extends SimpleMarkovProcess<KanbanState, KanbanEvent> {
    private double[] mu;
    private int m;
    private int[] kanban;

    public Kanban(int m, int[] kanban, double[] mu, int[] s) {
        super(new KanbanState(s, new int[m], kanban), KanbanEvent.getAllEvents(m));
        this.m = m;
        this.mu = mu;
        this.kanban = kanban;
    }

    public Kanban() {
        int[] nArray = new int[3];
        nArray[0] = 1;
        this(3, new int[]{2, 2}, new double[]{2.0, 2.0, 2.0}, nArray);
    }

    @Override
    public String description() {
        String stg = "KANBAN SYSTEM \n" + this.m + " Stations.";
        int i = 0;
        while (i < this.m) {
            stg = String.valueOf(stg) + "\nStation " + (i + 1) + ": Rate = " + this.mu[i] + (i < this.m - 1 ? ", Kanbans after station: " + this.kanban[i] : "");
            ++i;
        }
        return stg;
    }

    @Override
    public boolean active(KanbanState i, KanbanEvent e) {
        return i.getStatus(e.getStation()) == 1;
    }

    @Override
    public States<KanbanState> dests(KanbanState i, KanbanEvent ev) {
        int[] newBuff = new int[this.m];
        int e = ev.getStation();
        int j = 1;
        while (j < this.m) {
            newBuff[j] = i.getBuffer(j);
            ++j;
        }
        int[] newKanban = new int[this.m - 1];
        int j2 = 0;
        while (j2 < this.m - 1) {
            newKanban[j2] = i.getKanban(j2);
            ++j2;
        }
        int[] newStatus = new int[this.m];
        int j3 = 0;
        while (j3 < this.m) {
            newStatus[j3] = i.getStatus(j3);
            ++j3;
        }
        newStatus[e] = 0;
        if (e == 0) {
            newBuff[1] = newBuff[1] + 1;
            if (this.m == 2 && newStatus[1] == 0) {
                newStatus[1] = 1;
                newKanban[0] = newKanban[0] + 1;
                newBuff[1] = newBuff[1] - 1;
            }
            if (this.m > 2 && newKanban[1] > 0 && newStatus[1] == 0) {
                newStatus[1] = 1;
                newKanban[0] = newKanban[0] + 1;
                newKanban[1] = newKanban[1] - 1;
                newBuff[1] = newBuff[1] - 1;
            }
            if (newKanban[0] > 0) {
                newStatus[0] = 1;
                newKanban[0] = newKanban[0] - 1;
            }
            return new StatesSet<KanbanState>(new KanbanState(newStatus, newBuff, newKanban));
        }
        if (e == this.m - 1) {
            if (newBuff[e] > 0) {
                newStatus[e] = 1;
                newKanban[e - 1] = newKanban[e - 1] + 1;
                newBuff[e] = newBuff[e] - 1;
            }
        } else {
            newBuff[e + 1] = newBuff[e + 1] + 1;
            if (e < this.m - 2 && newKanban[e + 1] > 0 && newStatus[e + 1] == 0) {
                newStatus[e + 1] = 1;
                newKanban[e] = newKanban[e] + 1;
                newKanban[e + 1] = newKanban[e + 1] - 1;
                newBuff[e + 1] = newBuff[e + 1] - 1;
            }
            if (e == this.m - 2 && newStatus[e + 1] == 0) {
                newStatus[e + 1] = 1;
                newKanban[e] = newKanban[e] + 1;
                newBuff[e + 1] = newBuff[e + 1] - 1;
            }
            if (newKanban[e] > 0 && newBuff[e] > 0) {
                newStatus[e] = 1;
                newKanban[e - 1] = newKanban[e - 1] + 1;
                newKanban[e] = newKanban[e] - 1;
                newBuff[e] = newBuff[e] - 1;
            }
        }
        j3 = e - 1;
        while (j3 >= 0) {
            if (newStatus[j3] == 1) {
                return new StatesSet<KanbanState>(new KanbanState(newStatus, newBuff, newKanban));
            }
            if (j3 == 0) {
                if (newKanban[j3] > 0) {
                    newStatus[j3] = 1;
                    newKanban[j3] = newKanban[j3] - 1;
                }
                return new StatesSet<KanbanState>(new KanbanState(newStatus, newBuff, newKanban));
            }
            if (newBuff[j3] == 0 || newKanban[j3] == 0) {
                return new StatesSet<KanbanState>(new KanbanState(newStatus, newBuff, newKanban));
            }
            newStatus[j3] = 1;
            newKanban[j3 - 1] = newKanban[j3 - 1] + 1;
            newKanban[j3] = newKanban[j3] - 1;
            newBuff[j3] = newBuff[j3] - 1;
            --j3;
        }
        return new StatesSet<KanbanState>(new KanbanState(newStatus, newBuff, newKanban));
    }

    @Override
    public double rate(KanbanState i, KanbanState j, KanbanEvent e) {
        return this.mu[e.getStation()];
    }

    public static void main(String[] a) {
        int[] tarj = new int[]{2, 2};
        double[] mu = new double[]{2.0, 2.0, 2.0};
        int[] nArray = new int[3];
        nArray[0] = 1;
        int[] s = nArray;
        Kanban theKanban = new Kanban(s.length, tarj, mu, s);
        theKanban.showGUI();
        theKanban.generate();
        theKanban.printAll();
    }
}

