/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.basic.Event;
import jmarkov.basic.EventsSet;
import jphase.PhaseVar;

class HiperExQueueEvent
extends Event {
    Type type;
    private int curPH;

    HiperExQueueEvent() {
        this.type = Type.ARRIVAL;
    }

    HiperExQueueEvent(Type type, int phase) {
        this.type = type;
        this.curPH = phase;
    }

    public int getCurPH() {
        if (this.type == Type.ARRIVAL) {
            throw new IllegalArgumentException("Current phase is not defined for event " + (Object)((Object)Type.ARRIVAL));
        }
        return this.curPH;
    }

    public Type getType() {
        return this.type;
    }

    static EventsSet<HiperExQueueEvent> getAllEvents(PhaseVar phaseVar) {
        EventsSet<HiperExQueueEvent> E = new EventsSet<HiperExQueueEvent>();
        E.add(new HiperExQueueEvent());
        int numPhases = phaseVar.getNumPhases();
        int n = 1;
        while (n <= numPhases) {
            E.add(new HiperExQueueEvent(Type.FINISH_SERVICE, n));
            ++n;
        }
        return E;
    }

    @Override
    public String label() {
        String stg = "";
        switch (this.type) {
            case ARRIVAL: {
                stg = "Arrival";
                break;
            }
            case FINISH_SERVICE: {
                stg = "Ph(" + this.curPH + ")";
            }
        }
        return stg;
    }

    public static enum Type {
        ARRIVAL,
        FINISH_SERVICE;

    }
}

