/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.HiperExQueueEvent;
import examples.jmarkov.HiperExQueueState;
import jmarkov.GeomProcess;
import jmarkov.GeomRelState;
import jmarkov.basic.StatesSet;
import jphase.DenseContPhaseVar;
import jphase.PhaseVar;

public class HiperExQueue
extends GeomProcess<HiperExQueueState, HiperExQueueEvent> {
    private double lambda;
    private PhaseVar servDist = null;

    public HiperExQueue(double lambda, PhaseVar dists) {
        super(new HiperExQueueState(0), HiperExQueueEvent.getAllEvents(dists));
        this.lambda = lambda;
        this.servDist = dists;
    }

    public HiperExQueue() {
        this(1.0, DenseContPhaseVar.HyperExpo(new double[]{8.0, 8.0}, new double[]{0.5, 0.5}));
    }

    void addDestsFinishServer(int relLevel, StatesSet<GeomRelState<HiperExQueueState>> destStates) {
        PhaseVar v = this.servDist;
        double[] alpha = v.getVectorArray();
        int m = v.getNumPhases();
        int n = 0;
        while (n < m) {
            if (alpha[n] > 0.0) {
                GeomRelState<HiperExQueueState> gs = new GeomRelState<HiperExQueueState>(new HiperExQueueState(n + 1), relLevel);
                destStates.add(gs);
            }
            ++n;
        }
    }

    @Override
    public boolean active(HiperExQueueState i, int iLevel, HiperExQueueEvent e) {
        boolean result = false;
        switch (e.type) {
            case ARRIVAL: {
                result = true;
                break;
            }
            case FINISH_SERVICE: {
                result = i.getSrvPhase() == e.getCurPH();
            }
        }
        return result;
    }

    @Override
    public GeomRelState<HiperExQueueState>[] dests(HiperExQueueState i, int absLevel, HiperExQueueEvent e) {
        StatesSet<GeomRelState<HiperExQueueState>> destStates = new StatesSet<GeomRelState<HiperExQueueState>>();
        int newPhase = i.getSrvPhase();
        int rLevel = 0;
        switch (e.type) {
            case ARRIVAL: {
                rLevel = 1;
                if (absLevel == 0) {
                    this.addDestsFinishServer(rLevel, destStates);
                    break;
                }
                destStates.add(new GeomRelState<HiperExQueueState>(new HiperExQueueState(newPhase), rLevel));
                break;
            }
            case FINISH_SERVICE: {
                rLevel = -1;
                if (absLevel == 1) {
                    destStates.add(new GeomRelState<HiperExQueueState>(new HiperExQueueState(0)));
                    break;
                }
                this.addDestsFinishServer(rLevel, destStates);
            }
        }
        return (GeomRelState[])destStates.toStateArray();
    }

    @Override
    public double rate(HiperExQueueState i, int iLevel, HiperExQueueState j, int jLevel, HiperExQueueEvent e) {
        double rate = -1.0;
        double[] a = this.servDist.getMat0Array();
        switch (e.type) {
            case ARRIVAL: {
                if (iLevel == 0) {
                    int newPhase = j.getSrvPhase();
                    double[] alpha = this.servDist.getVectorArray();
                    rate = this.lambda * alpha[newPhase - 1];
                    break;
                }
                rate = this.lambda;
                break;
            }
            case FINISH_SERVICE: {
                if (iLevel > 1) {
                    int newPhase = j.getSrvPhase();
                    double[] alpha = this.servDist.getVectorArray();
                    rate = a[e.getCurPH() - 1] * alpha[newPhase - 1];
                    break;
                }
                rate = a[e.getCurPH() - 1];
            }
        }
        return rate;
    }

    @Override
    public String description() {
        return "Line of PH stations";
    }

    public static void main(String[] a) {
        double lambda = 1.0;
        DenseContPhaseVar v1 = DenseContPhaseVar.HyperExpo(new double[]{8.0, 8.0}, new double[]{0.5, 0.5});
        HiperExQueue model = new HiperExQueue(lambda, v1);
        model.showGUI();
        model.generate();
        model.setDebugLevel(0);
        model.printAll();
    }
}

