/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.AccessControl2QueuesEvent;
import examples.jmarkov.AccessControl2QueuesState;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Random;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;
import jmarkov.solvers.JamaSolver;

public class AccessControl2Queues
extends SimpleMarkovProcess<AccessControl2QueuesState, AccessControl2QueuesEvent> {
    private int B;
    private double Mu1;
    private double Mu2;
    private double L;
    private double c1;
    private double c2;
    private boolean pol;

    public AccessControl2Queues(int B, double L, double Mu1, double Mu2, double c1, double c2, boolean pol, int[] length) {
        super(new AccessControl2QueuesState(length), AccessControl2QueuesEvent.getAllEvents());
        this.B = B;
        this.Mu1 = Mu1;
        this.Mu2 = Mu2;
        this.c1 = c1;
        this.c2 = c2;
        this.L = L;
        this.pol = pol;
    }

    public AccessControl2Queues() {
        this(1, 1.0, 10.0, 1.0, 1.0, 20.0, true, new int[2]);
    }

    @Override
    public boolean active(AccessControl2QueuesState i, AccessControl2QueuesEvent e) {
        boolean result = false;
        int Q1 = i.getFirst() + e.getFirst();
        int Q2 = i.getSecond() + e.getSecond();
        if (e.getType() == AccessControl2QueuesEvent.Type.LOSS) {
            result = i.getFirst() == 1 && Q1 == 0 && i.getSecond() == this.B && Q2 == this.B;
        } else {
            boolean bl = result = Q1 >= 0 && Q1 <= 1 && Q2 >= 0 && Q2 <= this.B;
        }
        if (!this.pol && Q1 == 1 && Q2 == this.B) {
            result = false;
        }
        return result;
    }

    @Override
    public States<AccessControl2QueuesState> dests(AccessControl2QueuesState i, AccessControl2QueuesEvent e) {
        int[] origin = i.getProperties();
        return new StatesSet<AccessControl2QueuesState>(i.Trans(origin, e));
    }

    @Override
    public double rate(AccessControl2QueuesState i, AccessControl2QueuesState j, AccessControl2QueuesEvent e) {
        int[] origin = i.getProperties();
        int[] dest = j.getProperties();
        switch (e.getType()) {
            case ADMIT: {
                if (origin[0] != dest[0] - 1) break;
                return this.L;
            }
            case COMP_1: {
                if (origin[0] != dest[0] + 1 || origin[1] != dest[1] - 1) break;
                return this.Mu1;
            }
            case COMP_2: {
                if (origin[1] != dest[1] + 1) break;
                return this.Mu2;
            }
            default: {
                if (origin[0] != 1 || origin[1] != this.B || dest[0] != 0 || dest[1] != this.B) break;
                return this.Mu1;
            }
        }
        return 0.0;
    }

    @Override
    public String description() {
        String stg = "Access control to a 2 tandem queue system \n\nThere are " + this.B + " spaces in the buffer\n";
        stg = String.valueOf(stg) + "The arrival rate is " + this.L + ".\n";
        stg = String.valueOf(stg) + "The service rate at station 1 is " + this.Mu1 + ".\n";
        stg = String.valueOf(stg) + "The service rate at station 2 is " + this.Mu2 + ".\n";
        StringWriter sw = new StringWriter();
        stg = String.valueOf(stg) + sw.toString();
        return stg;
    }

    @Override
    public int printMOPs(PrintWriter out, int width, int decimals) {
        out.printf("    Buffer Size   = %6d ", this.B);
        out.printf("\n    Total Cost   = %6f ", this.getCost());
        out.println();
        return 0;
    }

    public static void main(String[] a) {
        boolean runOne = false;
        boolean runRandom = true;
        if (runOne) {
            AccessControl2Queues ACQ = new AccessControl2Queues();
            double cost = -1.0;
            int tries = 1;
            while (cost == -1.0 && tries <= 10) {
                ACQ.reset();
                cost = ACQ.getCost();
                ++tries;
            }
            ACQ.setDebugLevel(4);
            ACQ.showGUI();
            ACQ.printAll();
            ACQ.printMOPs();
        } else {
            double pZeroBGreedy;
            double pZeroBPrudent;
            double greed = 0.0;
            double prude = 0.0;
            boolean greedy = true;
            String stg = "Buffer \t Lam \t Mu1 \t Mu2 \t C1 \t C2 \t GreedyCost \t PrudentCost \t Prudent_0_B \t Greedy_0_B \t Greedy_1_B \t cStar \n";
            if (runRandom) {
                pZeroBPrudent = 0.0;
                pZeroBGreedy = 0.0;
                double pOneBGreedy = 0.0;
                Random randGen = new Random(123456L);
                Random randTwo = new Random(654321L);
                int i = 1;
                while (i <= 1000) {
                    double c2;
                    double c1 = randGen.nextDouble() * 999.0 + 1.0;
                    if (c1 >= (c2 = randGen.nextDouble() * 999.0 + 1.0)) {
                        --i;
                    } else {
                        System.out.print("\n i = ");
                        System.out.print(i);
                        double l = randGen.nextDouble() * 99.0 + 1.0;
                        double m1 = randGen.nextDouble() * 99.0 + 1.0;
                        double m2 = randGen.nextDouble() * 99.0 + 1.0;
                        int x = 1;
                        if (m2 < m1 && m2 < l) {
                            x = 5;
                        } else if (m1 < m2 && m1 < l) {
                            x = 2;
                        }
                        c1 = randTwo.nextDouble() * 999.0 + 1.0;
                        c2 = c1 * (1.0 + randTwo.nextDouble() / (double)x);
                        int b = 1;
                        while (b <= 500) {
                            if (b > 50) {
                                b += 49;
                            }
                            AccessControl2Queues ACQ1 = new AccessControl2Queues(b, l, m1, m2, c1, c2, greedy, new int[2]);
                            ACQ1.setSteadyStateSolver(new JamaSolver(ACQ1));
                            ACQ1.setMaxStates(10010L);
                            int tries = 1;
                            greed = -1.0;
                            while (greed == -1.0 && tries <= 10) {
                                ACQ1.reset();
                                greed = ACQ1.getCost();
                                ++tries;
                            }
                            DecimalFormat df1 = new DecimalFormat("#.###");
                            DecimalFormat df2 = new DecimalFormat("#.#######");
                            pZeroBGreedy = ACQ1.getProb(0, b);
                            pOneBGreedy = ACQ1.getProb(1, b);
                            tries = 1;
                            AccessControl2Queues ACQ2 = new AccessControl2Queues(b, l, m1, m2, c1, c2, !greedy, new int[2]);
                            ACQ2.setSteadyStateSolver(new JamaSolver(ACQ2));
                            ACQ2.setMaxStates(10010L);
                            prude = -1.0;
                            while (prude == -1.0 && tries <= 10) {
                                ACQ2.reset();
                                prude = ACQ2.getCost();
                                ++tries;
                            }
                            pZeroBPrudent = ACQ2.getProb(0, b);
                            tries = 0;
                            stg = String.valueOf(stg) + b + "\t " + df1.format(l) + "\t " + df1.format(m1) + "\t " + df1.format(m2) + "\t " + df1.format(c1) + "\t " + df1.format(c2) + "\t " + df1.format(greed) + "\t " + df1.format(prude) + " \t " + df2.format(pZeroBPrudent) + " \t " + df2.format(pZeroBGreedy) + " \t " + df2.format(pOneBGreedy) + "\n";
                            ++b;
                        }
                    }
                    ++i;
                }
            } else {
                pZeroBPrudent = 0.0;
                pZeroBGreedy = 0.0;
                double pOneBGreedy = 0.0;
                int[] e = new int[]{1, 2};
                int i = 0;
                while (i < e.length) {
                    int b = e[i];
                    int j = 0;
                    while (j < e.length) {
                        float l = e[j];
                        int k = 0;
                        while (k < e.length) {
                            float m1 = e[k];
                            int r = 0;
                            while (r < e.length) {
                                float m2 = e[r];
                                int t = 0;
                                while (t < e.length) {
                                    float c1 = e[t];
                                    int u = 0;
                                    while (u < e.length) {
                                        float c2 = e[u];
                                        AccessControl2Queues ACQ1 = new AccessControl2Queues(b, l, m1, m2, c1, c2, greedy, new int[2]);
                                        int tries = 1;
                                        greed = -1.0;
                                        while (greed == -1.0 && tries <= 10) {
                                            ACQ1.reset();
                                            greed = ACQ1.getCost();
                                            ++tries;
                                        }
                                        pZeroBGreedy = ACQ1.getProb(0, b);
                                        pOneBGreedy = ACQ1.getProb(1, b);
                                        tries = 1;
                                        AccessControl2Queues ACQ2 = new AccessControl2Queues(b, l, m1, m2, c1, c2, !greedy, new int[2]);
                                        prude = -1.0;
                                        while (prude == -1.0 && tries <= 10) {
                                            ACQ2.reset();
                                            prude = ACQ2.getCost();
                                            ++tries;
                                        }
                                        pZeroBPrudent = ACQ2.getProb(0, b);
                                        tries = 0;
                                        stg = String.valueOf(stg) + b + "\t " + l + "\t " + m1 + "\t " + m2 + "\t " + c1 + "\t " + c2 + "\t " + greed + "\t " + prude + " \t " + pZeroBPrudent + " \t " + pZeroBGreedy + " \t " + pOneBGreedy + "\n";
                                        ++u;
                                    }
                                    ++t;
                                }
                                ++r;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            try {
                FileWriter outFile = new FileWriter("C:/Users/Owner/Documents/HomePC Files/Daniel Universidad/MIIND/Tesis/jMarkov2_0a/examples/jmarkov/AccessControlFiles/result.txt");
                PrintWriter out = new PrintWriter(outFile);
                StringWriter sw = new StringWriter();
                stg = String.valueOf(stg) + sw.toString();
                out.print(stg);
                out.close();
            }
            catch (IOException EE) {
                EE.printStackTrace();
            }
        }
    }

    public int getB() {
        return this.B;
    }

    public double getMu1() {
        return this.Mu1;
    }

    public double getMu2() {
        return this.Mu2;
    }

    public double getLambda() {
        return this.L;
    }

    public double getCost() {
        double cost;
        AccessControl2QueuesState[] states;
        double[] probs;
        block9: {
            probs = this.getSteadyState();
            states = (AccessControl2QueuesState[])this.getStates().toStateArray();
            cost = 0.0;
            double totprob = 0.0;
            double[] dArray = probs;
            int n = probs.length;
            int n2 = 0;
            while (n2 < n) {
                double i = dArray[n2];
                totprob += i;
                ++n2;
            }
            if (!(totprob < 0.99) && !(totprob > 1.01)) break block9;
            return -1.0;
        }
        try {
            int i = 0;
            while (i < states.length) {
                if (states[i].getFirst() == 1) {
                    cost += this.c1 * this.L * probs[i];
                    if (states[i].getSecond() == this.B) {
                        cost += this.c2 * this.Mu1 * probs[i];
                    }
                } else if (!this.pol && states[i].getFirst() == 0 && states[i].getSecond() == this.B) {
                    cost += this.c1 * this.L * probs[i];
                }
                ++i;
            }
            return cost;
        }
        catch (NotUnichainException e) {
            return 0.0;
        }
    }

    public double getProb(int k, int l) {
        double prob;
        AccessControl2QueuesState[] states;
        double[] probs;
        block6: {
            probs = this.getSteadyState();
            states = (AccessControl2QueuesState[])this.getStates().toStateArray();
            double totprob = 0.0;
            prob = 0.0;
            double[] dArray = probs;
            int n = probs.length;
            int n2 = 0;
            while (n2 < n) {
                double j = dArray[n2];
                totprob += j;
                ++n2;
            }
            if (!(totprob < 0.99) && !(totprob > 1.01)) break block6;
            return -1.0;
        }
        try {
            int i = 0;
            while (i < states.length) {
                if (states[i].getFirst() == k && states[i].getSecond() == l) {
                    prob = probs[i];
                }
                ++i;
            }
            return prob;
        }
        catch (NotUnichainException e) {
            return 0.0;
        }
    }
}

