.TH DRAN 3 "14 July 2000" "Version 1.00"
.\" WARNING: This file was produced automatically from file common/dran.f
.\" by fortran-to-man-page.awk on Sun Dec 31 09:02:09 MST 2000.
.\" Any manual changes will be lost if this file is regenerated!
.SH NAME
dran \- Double-precision pseudo-random number
.\"=====================================================================
.SH SYNOPSIS
Fortran (77, 90, 95, HPF):
.RS
.B f77
.I "[ flags ] file(s) .\|.\|. -L/usr/local/lib -lgjl"
.RS
.nf
.B "DOUBLE PRECISION FUNCTION dran()"
.fi
.RE
.RE
C (K&R, 89, 99), C++ (98):
.RS
.B cc
.I "[ flags ] -I/usr/local/include file(s) .\|.\|. -L/usr/local/lib -lgjl"
.br
Use
.RS
.B "#include <gampsi.h>"
.RE
to get this prototype:
.RS
.B "fortran_double_precision dran(void);"
.RE
.RE
.PP
NB: The definition of C/C++ data types
.B fortran_
.IR xxx ,
and the mapping of Fortran external names to C/C++ external names,
is handled by the C/C++ header file.  That way, the same function
or subroutine name can be used in C, C++, and Fortran code,
independent of compiler conventions for mangling of external
names in these programming languages.
.PP
Last code modification: 14-Jul-2000
.\"=====================================================================
.SH DESCRIPTION
Generate and return a double-precision pseudo-random number from
the interval (0.0, 1.0). The significand of the returned value
should have about 58 pseudo-random bits. This is sufficient for
most arithmetic systems: in IEEE 754 arithmetic, the fractional
part of the double-precision significand has only 52 bits.
.PP
The initial generator seed is the same on the first call to this
function after every program startup, so that the sequence of
pseudo-random number is reproducible. This routine has no
provision for the user to alter the initial seed.
.PP
The algorithm is based on ``ACM Algorithm 266: Pseudo-Random
Numbers'', by M. C. Pike and I. D. Hill, Communications of the
ACM, Vol. 8, No. 10, 605--606, October 1965, modified by
Hansson, and later used in the book ``Software Manual for the
Elementary Functions'', by W. J. Cody, Jr. and W. Waite,
Prentice-Hall (1980), ISBN 0-13-822064-6.
.\"=====================================================================
.SH "SEE ALSO"
.BR ran (3).
.\"=====================================================================
.SH AUTHORS
The algorithms and code are described in detail in
the paper
.RS
.I "Algorithm xxx: Quadruple-Precision Gamma(x) and psi(x) Functions for Real Arguments"
.RE
in ACM Transactions on Mathematical Software,
Volume ??, Number ??, Pages ????--???? and
????--????, 2001, by
.RS
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
.fi
.RE
and
.RS
.nf
James S. Ball
University of Utah
Department of Physics
Salt Lake City, UT 84112-0830
USA
Tel: +1 801 581 8397
FAX: +1 801 581 6256
Email: \fCball@physics.utah.edu\fP
WWW URL: \fChttp://www.physics.utah.edu/people/faculty/ball.html\fP
.fi
.RE
.\"==============================[The End]==============================
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
